/*
 * Decompiled with CFR 0.152.
 */
package com.github.fartherp.framework.common.util;

import au.com.bytecode.opencsv.CSVWriter;
import com.github.fartherp.framework.common.util.FileUtilies;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CsvUtil {
    public static void writeCsvFile(HttpServletResponse response, HttpServletRequest request, String filename, String[] title, List<String[]> bodyList) {
        CSVWriter writer = null;
        try {
            response.setContentType("application/octet-stream;charset=GBK");
            String fileName = FileUtilies.getFileName(filename, request);
            response.setHeader("Content-Disposition", "attachment; filename=" + fileName + ".csv");
            writer = new CSVWriter((Writer)response.getWriter());
            if (title != null && title.length > 0) {
                writer.writeNext(title);
            }
            if (bodyList != null && bodyList.size() > 0) {
                writer.writeAll(bodyList);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("write csv file of response fail ", e);
        }
        finally {
            try {
                if (writer != null) {
                    writer.close();
                }
            }
            catch (IOException e) {}
        }
    }

    public static void writeCsvFile(String filename, String[] title, List<String[]> bodyList) {
        CSVWriter writer = null;
        OutputStreamWriter osw = null;
        try {
            osw = new OutputStreamWriter((OutputStream)new FileOutputStream(new File(filename + ".csv")), "GBK");
            writer = new CSVWriter((Writer)osw);
            if (title != null && title.length > 0) {
                writer.writeNext(title);
            }
            if (bodyList != null && bodyList.size() > 0) {
                writer.writeAll(bodyList);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("write csv file fail ", e);
        }
        finally {
            try {
                if (osw != null) {
                    osw.close();
                }
                if (writer != null) {
                    writer.close();
                }
            }
            catch (IOException e) {}
        }
    }

    public static String createCsvFile(List<List<Object>> outputList) {
        StringBuilder os = new StringBuilder();
        char returnChar = '\r';
        char lineChar = '\n';
        for (List<Object> unitList : outputList) {
            if (unitList == null || unitList.isEmpty()) continue;
            StringBuilder sb = new StringBuilder();
            for (Object unitOb : unitList) {
                String unit = "";
                if (unitOb != null) {
                    unit = unitOb.toString().replaceAll(",", "");
                }
                sb.append(unit);
                sb.append(",");
            }
            sb.deleteCharAt(sb.length() - 1);
            sb.append(returnChar);
            sb.append(lineChar);
            os.append((CharSequence)sb);
        }
        return os.toString();
    }
}

