/*
 * Decompiled with CFR 0.152.
 */
package com.github.fartherp.framework.common.util;

import com.github.fartherp.framework.common.util.ReflectUtil;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapUtils<K, V> {
    public static <K, V> MapPlain<K, V> build() {
        return new MapPlain();
    }

    public static <K, V> MapPlain<K, V> build(int cap) {
        return new MapPlain(cap);
    }

    public static Map<String, Object> toMap(Object o, Map<String, String> map, String ... ignoreProperties) {
        PropertyDescriptor[] ts = ReflectUtil.getPropertyDescriptors(o);
        List<String> ignoreList = ignoreProperties != null && ignoreProperties.length > 0 ? Arrays.asList(ignoreProperties) : null;
        HashMap<String, Object> m = new HashMap<String, Object>(ts.length);
        for (PropertyDescriptor t : ts) {
            Method r = t.getReadMethod();
            if (r == null || ignoreList != null && ignoreList.contains(t.getName())) continue;
            try {
                if (!Modifier.isPublic(r.getDeclaringClass().getModifiers())) {
                    r.setAccessible(true);
                }
                if (null != map && map.containsKey(t.getName())) {
                    m.put(map.get(t.getName()), r.invoke(o, new Object[0]));
                    continue;
                }
                m.put(t.getName(), r.invoke(o, new Object[0]));
            }
            catch (Throwable e) {
                throw new RuntimeException("Could not copy property '" + t.getName() + "' from source to target", e);
            }
        }
        return m;
    }

    public static Map<String, Object> toMap(Object o, String ... ignoreProperties) {
        return MapUtils.toMap(o, null, ignoreProperties);
    }

    public static void toObject(Map<String, Object> source, Object target, String ... ignoreProperties) {
        PropertyDescriptor[] ts = ReflectUtil.getPropertyDescriptors(target);
        List<String> ignoreList = ignoreProperties != null && ignoreProperties.length > 0 ? Arrays.asList(ignoreProperties) : null;
        for (PropertyDescriptor t : ts) {
            String name = t.getName();
            if (ignoreList != null && ignoreList.contains(name) || null == source || !source.containsKey(name)) continue;
            ReflectUtil.setValueByField(target, t.getName(), source.get(name));
        }
    }

    public static <K, V> List<Map<String, Object>> mapConvertToList(Map<K, V> map) {
        return MapUtils.mapConvertToList(map, null);
    }

    public static <K, V> List<Map<String, Object>> mapConvertToList(Map<K, V> map, Object defaultValue) {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        if (null == map || map.isEmpty()) {
            return list;
        }
        for (Map.Entry<K, V> entry : map.entrySet()) {
            HashMap<String, Object> result = new HashMap<String, Object>();
            result.put("text", entry.getValue().toString());
            result.put("value", entry.getKey());
            if (null != defaultValue && entry.getKey().toString().equals(defaultValue.toString())) {
                result.put("selected", true);
            }
            list.add(result);
        }
        return list;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MapPlain<K, V> {
        Map<K, V> map;

        public MapPlain() {
            this(0);
        }

        public MapPlain(int cap) {
            this.map = new HashMap(cap);
        }

        public MapPlain<K, V> put(K key, V value) {
            this.map.put(key, value);
            return this;
        }

        public MapPlain<K, V> putAll(Map<K, V> map) {
            if (map == null) {
                return this;
            }
            this.map.putAll(map);
            return this;
        }

        public Map<K, V> get() {
            return this.map;
        }
    }
}

