/*
 * Decompiled with CFR 0.152.
 */
package com.github.fartherp.framework.common.util;

import java.io.UnsupportedEncodingException;
import java.net.URLConnection;
import java.net.URLEncoder;
import javax.mail.internet.MimeUtility;
import org.apache.commons.lang.StringUtils;

public class WebUtils {
    public static String guessContentType(String fileName) {
        return URLConnection.getFileNameMap().getContentTypeFor(fileName);
    }

    public static String encodeContentDisposition(String userAgent, String fileName) {
        try {
            String lowUserAgent = userAgent.toLowerCase();
            if (lowUserAgent.indexOf("msie") != -1 || lowUserAgent.indexOf("trident") != -1) {
                return "attachment;filename=" + StringUtils.replace((String)URLEncoder.encode(fileName, "UTF-8"), (String)"+", (String)"%20");
            }
            if (lowUserAgent.indexOf("opera") != -1) {
                return "attachment;filename*=UTF-8''" + fileName;
            }
            if (lowUserAgent.indexOf("safari") != -1 || lowUserAgent.indexOf("applewebkit") != -1 || lowUserAgent.indexOf("mozilla") != -1) {
                return "attachment;filename=" + new String(fileName.getBytes("UTF-8"), "ISO8859-1");
            }
            return "attachment;filename=" + MimeUtility.encodeWord((String)fileName);
        }
        catch (UnsupportedEncodingException e) {
            String charset = MimeUtility.getDefaultJavaCharset();
            throw new RuntimeException("default java charset [" + charset + "]", e);
        }
    }
}

