/*
 * Decompiled with CFR 0.152.
 */
package com.github.fartherp.framework.common.validate;

import com.github.fartherp.framework.common.util.OutputUtils;
import com.github.fartherp.framework.common.validate.ExpandValidation;
import com.github.fartherp.framework.common.validate.ExpandValidator;
import java.util.Locale;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.groups.Default;
import org.hibernate.validator.HibernateValidator;
import org.hibernate.validator.HibernateValidatorConfiguration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValidateUtils {
    public static <T> void validate(T bean, Class<?> ... groups) {
        ValidateUtils.validate(bean, true, groups);
    }

    public static <T> void validate(T bean, boolean flag, Class<?> ... groups) {
        Class[] classArray;
        StringBuilder sb = new StringBuilder();
        if (groups == null || groups.length == 0) {
            Class[] classArray2 = new Class[1];
            classArray = classArray2;
            classArray2[0] = Default.class;
        } else {
            classArray = groups;
        }
        Class[] group = classArray;
        ValidatorFactory validatorFactory = ((HibernateValidatorConfiguration)Validation.byProvider(HibernateValidator.class).configure()).failFast(flag).buildValidatorFactory();
        Validator validator = validatorFactory.getValidator();
        Set constraintViolations = validator.validate(bean, group);
        if (!constraintViolations.isEmpty()) {
            for (ConstraintViolation constraint : constraintViolations) {
                sb.append(constraint.getMessage());
                OutputUtils.newLine(sb);
            }
        }
        if (sb.length() > 0) {
            throw new IllegalArgumentException(sb.toString());
        }
    }

    public static <T> void validate(T bean, Locale locale, Class<?> ... groups) {
        Class[] classArray;
        StringBuilder sb = new StringBuilder();
        if (groups == null || groups.length == 0) {
            Class[] classArray2 = new Class[1];
            classArray = classArray2;
            classArray2[0] = Default.class;
        } else {
            classArray = groups;
        }
        Class[] group = classArray;
        ValidatorFactory validatorFactory = ((HibernateValidatorConfiguration)ExpandValidation.byProvider(ExpandValidator.class).configure(locale)).buildValidatorFactory();
        Validator validator = validatorFactory.getValidator();
        Set constraintViolations = validator.validate(bean, group);
        if (!constraintViolations.isEmpty()) {
            for (ConstraintViolation constraint : constraintViolations) {
                sb.append(constraint.getMessage());
                OutputUtils.newLine(sb);
            }
        }
        if (sb.length() > 0) {
            throw new IllegalArgumentException(sb.toString());
        }
    }
}

