/*
 * Decompiled with CFR 0.152.
 */
package base64;

import base64.Base64;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;

public class Base64Utils {
    private static final int CACHE_SIZE = 1024;

    public static byte[] decode(String base64) {
        return Base64.decode(base64.getBytes());
    }

    public static String encode(byte[] bytes) {
        return new String(Base64.encode(bytes));
    }

    public static String encodeFile(String filePath) {
        byte[] bytes = Base64Utils.fileToByte(filePath);
        return Base64Utils.encode(bytes);
    }

    public static void decodeToFile(String filePath, String base64) {
        byte[] bytes = Base64Utils.decode(base64);
        Base64Utils.byteArrayToFile(bytes, filePath);
    }

    public static byte[] fileToByte(String filePath) {
        byte[] data = new byte[]{};
        File file = new File(filePath);
        if (file.exists()) {
            try {
                FileInputStream in = new FileInputStream(file);
                ByteArrayOutputStream out = new ByteArrayOutputStream(2048);
                byte[] cache = new byte[1024];
                int nRead = 0;
                while ((nRead = in.read(cache)) != -1) {
                    out.write(cache, 0, nRead);
                    out.flush();
                }
                out.close();
                in.close();
                data = out.toByteArray();
            }
            catch (Exception e) {
                throw new RuntimeException("\u6587\u4ef6\u8f6c\u6362\u4e8c\u8fdb\u5236\u6570\u636e", e);
            }
        }
        return data;
    }

    public static void byteArrayToFile(byte[] bytes, String filePath) {
        ByteArrayInputStream in = new ByteArrayInputStream(bytes);
        File destFile = new File(filePath);
        if (!destFile.getParentFile().exists()) {
            destFile.getParentFile().mkdirs();
        }
        try {
            destFile.createNewFile();
            FileOutputStream out = new FileOutputStream(destFile);
            byte[] cache = new byte[1024];
            int nRead = 0;
            while ((nRead = in.read(cache)) != -1) {
                ((OutputStream)out).write(cache, 0, nRead);
                out.flush();
            }
            ((OutputStream)out).close();
            ((InputStream)in).close();
        }
        catch (Exception e) {
            throw new RuntimeException("\u4e8c\u8fdb\u5236\u6570\u636e\u5199\u6587\u4ef6", e);
        }
    }
}

