/*
 * Decompiled with CFR 0.152.
 */
package com.github.fartherp.framework.common.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class BaseConfig {
    private Properties properties = new Properties();

    public BaseConfig(String path) {
        this.init(path);
    }

    private void init(String path) {
        InputStream in = BaseConfig.class.getClassLoader().getResourceAsStream(path);
        try {
            this.properties.load(in);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public String getString(Object key) {
        return this.properties.get(key).toString();
    }

    public boolean getBoolean(Object key) {
        return Boolean.parseBoolean(this.properties.get(key).toString());
    }

    public byte getByte(Object key) {
        return Byte.parseByte(this.properties.get(key).toString());
    }

    public short getShort(Object key) {
        return Short.parseShort(this.properties.get(key).toString());
    }

    public int getInt(Object key) {
        return Integer.parseInt(this.properties.get(key).toString());
    }

    public long getLong(Object key) {
        return Long.parseLong(this.properties.get(key).toString());
    }

    public float getFloat(Object key) {
        return Float.parseFloat(this.properties.get(key).toString());
    }

    public double getDouble(Object key) {
        return Double.parseDouble(this.properties.get(key).toString());
    }
}

