/*
 * Decompiled with CFR 0.152.
 */
package com.github.fartherp.framework.common.util;

import com.github.fartherp.framework.common.util.HttpClientUtils;
import com.github.fartherp.framework.common.util.JsonUtil;
import com.github.fartherp.framework.common.util.RemoteIpInfo;
import java.net.InetAddress;
import java.net.UnknownHostException;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;

public class IPUtils {
    public static final String SINA_PATH = "http://int.dpool.sina.com.cn/iplookup/iplookup.php?format=json&ip=";

    public static String getIP(HttpServletRequest request) {
        String ip = request.getHeader("x-forwarded-for");
        if (IPUtils.checkIP(ip)) {
            ip = request.getHeader("Proxy-Client-IP");
        }
        if (IPUtils.checkIP(ip)) {
            ip = request.getHeader("WL-Proxy-Client-IP");
        }
        if (IPUtils.checkIP(ip) && ((ip = request.getRemoteAddr()).equals("127.0.0.1") || ip.equals("0:0:0:0:0:0:0:1"))) {
            try {
                ip = InetAddress.getLocalHost().getHostAddress();
            }
            catch (UnknownHostException e) {
                e.printStackTrace();
            }
        }
        if (ip != null && ip.length() > 15) {
            ip = StringUtils.substringBefore((String)ip, (String)",");
        }
        return ip;
    }

    private static boolean checkIP(String ip) {
        return ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip);
    }

    public static RemoteIpInfo getAddress(String ip) {
        String resp = HttpClientUtils.executeGet(SINA_PATH + ip);
        return JsonUtil.fromJson(resp, RemoteIpInfo.class);
    }
}

