/*
 * Decompiled with CFR 0.152.
 */
package com.github.fartherp.framework.common.util;

import com.google.gson.ExclusionStrategy;
import com.google.gson.FieldAttributes;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Date;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JsonUtil {
    public static <T> T fromJson(String json, Class<T> clazz) {
        return (T)JsonUtil.gson(new String[0]).fromJson(json, clazz);
    }

    public static String toJson(Object obj, String ... ignoreProperties) {
        return JsonUtil.gson(ignoreProperties).toJson(obj);
    }

    public static Gson gson(String ... ignoreProperties) {
        String datePattern = "yyyy-MM-dd HH:mm:ss";
        GsonBuilder builder = new GsonBuilder();
        builder.setDateFormat(datePattern);
        ExclusionStrategy exclusionStrategy = JsonUtil.getExclusionStrategy(ignoreProperties);
        if (exclusionStrategy != null) {
            builder.setExclusionStrategies(new ExclusionStrategy[]{exclusionStrategy});
        }
        return builder.create();
    }

    public static Gson gson1(String ... ignoreProperties) {
        GsonBuilder builder = new GsonBuilder();
        builder.registerTypeAdapter(Date.class, (Object)new DateSerializer());
        builder.setDateFormat(1);
        ExclusionStrategy exclusionStrategy = JsonUtil.getExclusionStrategy(ignoreProperties);
        if (exclusionStrategy != null) {
            builder.setExclusionStrategies(new ExclusionStrategy[]{exclusionStrategy});
        }
        return builder.create();
    }

    public static ExclusionStrategy getExclusionStrategy(String ... ignoreProperties) {
        List<String> ignoreList;
        ExclusionStrategy exclusionStrategy = null;
        List<String> list = ignoreList = ignoreProperties != null && ignoreProperties.length > 0 ? Arrays.asList(ignoreProperties) : null;
        if (ignoreList != null) {
            exclusionStrategy = new ExclusionStrategy(){

                public boolean shouldSkipField(FieldAttributes fa) {
                    return ignoreList.contains(fa.getName());
                }

                public boolean shouldSkipClass(Class<?> clazz) {
                    return false;
                }
            };
        }
        return exclusionStrategy;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DateSerializer
    implements JsonSerializer<Date> {
        public JsonElement serialize(Date src, Type typeOfSrc, JsonSerializationContext context) {
            return new JsonPrimitive((Number)src.getTime());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DateDeserializer
    implements JsonDeserializer<Date> {
        public Date deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            return new Date(json.getAsJsonPrimitive().getAsLong());
        }
    }
}

