/*
 * Decompiled with CFR 0.152.
 */
package com.github.fartherp.framework.common.util;

import com.github.fartherp.framework.common.util.PrimitiveJavaType;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReflectUtil {
    public static PropertyDescriptor[] getPropertyDescriptors(Object obj) {
        try {
            BeanInfo beanInfo = Introspector.getBeanInfo(obj.getClass());
            return beanInfo.getPropertyDescriptors();
        }
        catch (IntrospectionException e) {
            throw new RuntimeException("Could not get '" + obj.getClass().getName() + "' class property", e);
        }
    }

    public static Field getFieldByFieldName(Object obj, String fieldName) {
        for (Class<?> searchType = obj.getClass(); !Object.class.equals(searchType) && searchType != null; searchType = searchType.getSuperclass()) {
            Field[] fields;
            for (Field field : fields = searchType.getDeclaredFields()) {
                if (!fieldName.equals(field.getName())) continue;
                return field;
            }
        }
        return null;
    }

    public static Field getFieldByFieldName(Class<?> searchType, String fieldName) {
        while (!Object.class.equals(searchType) && searchType != null) {
            Field[] fields;
            for (Field field : fields = searchType.getDeclaredFields()) {
                if (!fieldName.equals(field.getName())) continue;
                return field;
            }
            searchType = searchType.getSuperclass();
        }
        return null;
    }

    public static Object getValueByFieldName(Object obj, Field field) {
        Object value = null;
        if (field != null) {
            try {
                if (field.isAccessible()) {
                    value = field.get(obj);
                } else {
                    field.setAccessible(true);
                    value = field.get(obj);
                    field.setAccessible(false);
                }
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        return value;
    }

    public static Object getValueByFieldName(Object obj, String fieldName) {
        PropertyDescriptor[] ts;
        for (PropertyDescriptor t : ts = ReflectUtil.getPropertyDescriptors(obj)) {
            if (!t.getName().equals(fieldName)) continue;
            Method r = t.getReadMethod();
            try {
                Class<?> clazz = r.getDeclaringClass();
                if (!Modifier.isPublic(clazz.getModifiers())) {
                    r.setAccessible(true);
                }
                return r.invoke(obj, new Object[0]);
            }
            catch (Throwable e) {
                throw new RuntimeException("Could not get property '" + t.getName(), e);
            }
        }
        return null;
    }

    public static void setValueByFieldName(Object obj, String fieldName, Object value) {
        try {
            Field field = ReflectUtil.getFieldByFieldName(obj, fieldName);
            if (field.isAccessible()) {
                field.set(obj, value);
            } else {
                field.setAccessible(true);
                field.set(obj, value);
                field.setAccessible(false);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Could not set property '" + fieldName, e);
        }
    }

    public static void setValueByField(Object obj, String fieldName, Object value) {
        try {
            if (value != null) {
                Field field = ReflectUtil.getFieldByFieldName(obj, fieldName);
                Object tmp = PrimitiveJavaType.covertValue(field.getType(), value);
                if (field.isAccessible()) {
                    field.set(obj, tmp);
                } else {
                    field.setAccessible(true);
                    field.set(obj, tmp);
                    field.setAccessible(false);
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Could not set property '" + fieldName, e);
        }
    }
}

