/*
 * Decompiled with CFR 0.152.
 */
package com.github.fartherp.framework.common.validate;

import com.github.fartherp.framework.common.validate.ExpandProviderSpecificBootstrap;
import com.github.fartherp.framework.common.validate.ExpandValidationProvider;
import java.lang.ref.SoftReference;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.WeakHashMap;
import javax.validation.Configuration;
import javax.validation.ValidationException;
import javax.validation.ValidationProviderResolver;
import javax.validation.ValidatorFactory;
import javax.validation.bootstrap.GenericBootstrap;
import javax.validation.bootstrap.ProviderSpecificBootstrap;
import javax.validation.spi.BootstrapState;
import javax.validation.spi.ValidationProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExpandValidation {
    public static ValidatorFactory buildDefaultValidatorFactory(Locale locale) {
        return ExpandValidation.byDefaultProvider(locale).configure().buildValidatorFactory();
    }

    public static GenericBootstrap byDefaultProvider(Locale locale) {
        return new GenericBootstrapImpl(locale);
    }

    public static <T extends Configuration<T>, U extends ExpandValidationProvider<T>> ExpandProviderSpecificBootstrap<T> byProvider(Class<U> providerType) {
        return new ProviderSpecificBootstrapImpl(providerType);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class GetValidationProviderListAction
    implements PrivilegedAction<List<ValidationProvider<?>>> {
        private static final WeakHashMap<ClassLoader, SoftReference<List<ValidationProvider<?>>>> providersPerClassloader = new WeakHashMap();

        private GetValidationProviderListAction() {
        }

        public static List<ValidationProvider<?>> getValidationProviderList() {
            GetValidationProviderListAction action = new GetValidationProviderListAction();
            if (System.getSecurityManager() != null) {
                return (List)AccessController.doPrivileged(action);
            }
            return action.run();
        }

        @Override
        public List<ValidationProvider<?>> run() {
            ClassLoader classloader = Thread.currentThread().getContextClassLoader();
            List<ValidationProvider<?>> cachedContextClassLoaderProviderList = this.getCachedValidationProviders(classloader);
            if (cachedContextClassLoaderProviderList != null) {
                return cachedContextClassLoaderProviderList;
            }
            List<ValidationProvider<?>> validationProviderList = this.loadProviders(classloader);
            if (validationProviderList.isEmpty()) {
                classloader = DefaultValidationProviderResolver.class.getClassLoader();
                List<ValidationProvider<?>> cachedCurrentClassLoaderProviderList = this.getCachedValidationProviders(classloader);
                if (cachedCurrentClassLoaderProviderList != null) {
                    return cachedCurrentClassLoaderProviderList;
                }
                validationProviderList = this.loadProviders(classloader);
            }
            this.cacheValidationProviders(classloader, validationProviderList);
            return validationProviderList;
        }

        private List<ValidationProvider<?>> loadProviders(ClassLoader classloader) {
            ServiceLoader<ValidationProvider> loader = ServiceLoader.load(ValidationProvider.class, classloader);
            Iterator<ValidationProvider> providerIterator = loader.iterator();
            ArrayList validationProviderList = new ArrayList();
            while (providerIterator.hasNext()) {
                try {
                    validationProviderList.add(providerIterator.next());
                }
                catch (ServiceConfigurationError e) {}
            }
            return validationProviderList;
        }

        private synchronized List<ValidationProvider<?>> getCachedValidationProviders(ClassLoader classLoader) {
            SoftReference<List<ValidationProvider<?>>> ref = providersPerClassloader.get(classLoader);
            return ref != null ? ref.get() : null;
        }

        private synchronized void cacheValidationProviders(ClassLoader classLoader, List<ValidationProvider<?>> providers) {
            providersPerClassloader.put(classLoader, new SoftReference(providers));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DefaultValidationProviderResolver
    implements ValidationProviderResolver {
        private DefaultValidationProviderResolver() {
        }

        public List<ValidationProvider<?>> getValidationProviders() {
            return GetValidationProviderListAction.getValidationProviderList();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class GenericBootstrapImpl
    implements GenericBootstrap,
    BootstrapState {
        private ValidationProviderResolver resolver;
        private ValidationProviderResolver defaultResolver;
        private Locale locale;

        public GenericBootstrapImpl(Locale locale) {
            this.locale = locale;
        }

        public GenericBootstrap providerResolver(ValidationProviderResolver resolver) {
            this.resolver = resolver;
            return this;
        }

        public ValidationProviderResolver getValidationProviderResolver() {
            return this.resolver;
        }

        public ValidationProviderResolver getDefaultValidationProviderResolver() {
            if (this.defaultResolver == null) {
                this.defaultResolver = new DefaultValidationProviderResolver();
            }
            return this.defaultResolver;
        }

        public Configuration<?> configure() {
            Configuration<?> config;
            List validationProviders;
            ValidationProviderResolver resolver = this.resolver == null ? this.getDefaultValidationProviderResolver() : this.resolver;
            try {
                validationProviders = resolver.getValidationProviders();
            }
            catch (ValidationException e) {
                throw e;
            }
            catch (RuntimeException re) {
                throw new ValidationException("Unable to get available provider resolvers.", (Throwable)re);
            }
            if (validationProviders.size() == 0) {
                String msg = "Unable to create a Configuration, because no Bean Validation provider could be found. Add a provider like Hibernate Validator (RI) to your classpath.";
                throw new ValidationException(msg);
            }
            try {
                config = ((ExpandValidationProvider)resolver.getValidationProviders().get(0)).createGenericConfiguration(this, this.locale);
            }
            catch (RuntimeException re) {
                throw new ValidationException("Unable to instantiate Configuration.", (Throwable)re);
            }
            return config;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ProviderSpecificBootstrapImpl<T extends Configuration<T>, U extends ExpandValidationProvider<T>>
    implements ExpandProviderSpecificBootstrap<T> {
        private final Class<U> validationProviderClass;
        private ValidationProviderResolver resolver;

        public ProviderSpecificBootstrapImpl(Class<U> validationProviderClass) {
            this.validationProviderClass = validationProviderClass;
        }

        public ProviderSpecificBootstrap<T> providerResolver(ValidationProviderResolver resolver) {
            this.resolver = resolver;
            return this;
        }

        public T configure() {
            return null;
        }

        @Override
        public T configure(Locale locale) {
            List resolvers;
            if (this.validationProviderClass == null) {
                throw new ValidationException("builder is mandatory. Use Validation.byDefaultProvider() to use the generic provider discovery mechanism");
            }
            GenericBootstrapImpl state = new GenericBootstrapImpl(locale);
            if (this.resolver == null) {
                this.resolver = state.getDefaultValidationProviderResolver();
            } else {
                state.providerResolver(this.resolver);
            }
            try {
                resolvers = this.resolver.getValidationProviders();
            }
            catch (RuntimeException re) {
                throw new ValidationException("Unable to get available provider resolvers.", (Throwable)re);
            }
            for (ValidationProvider provider : resolvers) {
                if (!this.validationProviderClass.isAssignableFrom(provider.getClass())) continue;
                ExpandValidationProvider specificProvider = (ExpandValidationProvider)this.validationProviderClass.cast(provider);
                return specificProvider.createSpecializedConfiguration(state, locale);
            }
            throw new ValidationException("Unable to find provider: " + this.validationProviderClass);
        }
    }
}

