/*
 * Decompiled with CFR 0.152.
 */
package com.github.fartherp.framework.common.util;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class DateUtil {
    public static final String yyyyMMdd = "yyyyMMdd";
    public static final String yyyy_MM_dd = "yyyy-MM-dd";
    public static final String ddMMyy = "ddMMyy";
    public static final String yyyyMM = "yyyyMM";
    public static final String yyyy_MM_dd_HH_mm_ss = "yyyy-MM-dd HH:mm:ss";
    public static final String yyMMddHHmmss = "yyMMddHHmmss";
    public static final String yyyyMMddHH = "yyyyMMddHH";
    public static final String yyyyMMddHHmmss = "yyyyMMddHHmmss";
    public static final String HH_mm_ss = "HH:mm:ss";
    public static final String HHmmss = "HHmmss";
    public static final String HH_mm = "HH:mm";
    private static final ThreadLocal<Map<String, DateFormat>> threadLocal = new ThreadLocal();
    public static final long SECOND_TIME = 1000L;
    public static final long MINUTE_TIME = 60000L;
    public static final long HOUR_TIME = 3600000L;
    public static final long DAY_TIME = 86400000L;

    public static DateFormat getDateFormat(String format) {
        DateFormat dateFormat;
        Map<String, DateFormat> formatMap = threadLocal.get();
        if (formatMap == null) {
            formatMap = new HashMap<String, DateFormat>();
            threadLocal.set(formatMap);
        }
        if ((dateFormat = formatMap.get(format)) == null) {
            dateFormat = new SimpleDateFormat(format);
            formatMap.put(format, dateFormat);
        }
        return dateFormat;
    }

    public static String format(String format, Date date) {
        return date != null ? DateUtil.getDateFormat(format).format(date) : null;
    }

    public static Date parse(String format, String date) {
        if (StringUtils.isBlank((CharSequence)date)) {
            return null;
        }
        Date d = null;
        try {
            d = DateUtil.getDateFormat(format).parse(date);
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return d;
    }

    public static String getDateStr(Date date, String format, int i, int j) {
        if (date == null) {
            return null;
        }
        Date newDate = DateUtil.getDateByCalendar(date, i, j);
        return DateUtil.getDateFormat(format).format(newDate);
    }

    public static boolean isLeapYear(int year) {
        return year % 400 == 0 || year % 4 == 0 && year % 100 != 0;
    }

    public static int maxDayOfMonth(int year, int month) {
        if (month <= 0 || month > 12) {
            return -1;
        }
        int day = 0;
        switch (month) {
            case 2: {
                day = 28;
                break;
            }
            case 4: 
            case 6: 
            case 9: 
            case 11: {
                day = 30;
                break;
            }
            default: {
                day = 31;
            }
        }
        if (month == 2 && DateUtil.isLeapYear(year)) {
            ++day;
        }
        return day;
    }

    public static int year(Date date) {
        return DateUtil.getCurrentCalendar(date).get(1);
    }

    public static int month(Date date) {
        return DateUtil.getCurrentCalendar(date).get(2) + 1;
    }

    public static int day(Date date) {
        return DateUtil.getCurrentCalendar(date).get(5);
    }

    public static int getTimeNumber(Date date, int i) {
        return DateUtil.getCurrentCalendar(date).get(i);
    }

    public static int week(Date date) {
        int week = DateUtil.getCurrentCalendar(date).get(7) - 1;
        if (0 == week) {
            week = 7;
        }
        return week;
    }

    public static int getQuarter(Date date) {
        return (DateUtil.month(date) - 1) / 3 + 1;
    }

    public static int dayOfQuarter(Date date) {
        int month = DateUtil.month(date);
        int year = DateUtil.year(date);
        int day = 0;
        for (int i = month - (month - 1) % 3; i < month; ++i) {
            day += DateUtil.maxDayOfMonth(year, i);
        }
        return day += DateUtil.day(date);
    }

    public static int days(Date date) {
        int days = 0;
        int year = DateUtil.year(date) - 1;
        days += year * 365;
        days += year / 4;
        days -= year / 100;
        days += year / 400;
        return days += DateUtil.dayOfYear(date);
    }

    public static int dayOfYear(Date date) {
        int month = DateUtil.month(date);
        int year = DateUtil.year(date);
        int day = 0;
        for (int i = 1; i < month; ++i) {
            day += DateUtil.maxDayOfMonth(year, i);
        }
        return day += DateUtil.day(date);
    }

    public static String dateRedMonthBegin(Date date, int n) {
        String str = "";
        int year = DateUtil.year(date);
        int month = DateUtil.month(date);
        if (n >= 12) {
            int m = n % 12;
            int s = n / 12;
            month = 12 - m + month;
            year -= s;
        } else {
            month -= n;
        }
        if (month == 0) {
            --year;
            month = 12;
        }
        str = month < 10 ? "0" + month : month + "";
        return year + "-" + str + "-01";
    }

    public static String dateRedMonthEnd(Date date, int n) {
        String str = "";
        int year = DateUtil.year(date);
        int month = DateUtil.month(date);
        if (n >= 12) {
            int m = n % 12;
            int s = n / 12;
            month = 12 - m + month;
            year -= s;
        } else {
            month -= n;
        }
        if (month == 0) {
            --year;
            month = 12;
        }
        str = month < 10 ? "0" + month : month + "";
        return year + "-" + str + "-" + DateUtil.maxDayOfMonth(year, month);
    }

    public static Date getDateByCalendar(Date date, int i, int j) {
        Calendar c = DateUtil.getCurrentCalendar(date);
        c.add(i, j);
        return c.getTime();
    }

    private static Calendar getCurrentCalendar(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        return c;
    }

    public static long getBetweenDiff(Date startDate, Date endDate, long time) {
        long startDateTime = startDate.getTime();
        long endDateTime = endDate.getTime();
        return (endDateTime - startDateTime) / time;
    }

    public static boolean isDBDefaultDate(Date date) {
        if (null == date) {
            return false;
        }
        String dbDefault = DateUtil.format(yyyy_MM_dd_HH_mm_ss, date);
        return "1970-01-01 00:00:00".equals(dbDefault);
    }
}

