/*
 * Decompiled with CFR 0.152.
 */
package com.github.fartherp.framework.common.util;

import java.util.HashMap;
import java.util.Map;

public class MapDistance {
    public static final double EARTH_RADIUS = 6378.137;

    private static double rad(double d) {
        return d * Math.PI / 180.0;
    }

    public static double getDistance(double lng1, double lat1, double lng2, double lat2) {
        double radLat1 = MapDistance.rad(lng1);
        double radLat2 = MapDistance.rad(lng2);
        double difference = radLat1 - radLat2;
        double mdifference = MapDistance.rad(lat1) - MapDistance.rad(lat2);
        double distance = 2.0 * Math.asin(Math.sqrt(Math.pow(Math.sin(difference / 2.0), 2.0) + Math.cos(radLat1) * Math.cos(radLat2) * Math.pow(Math.sin(mdifference / 2.0), 2.0)));
        distance *= 6378.137;
        distance = Math.round(distance * 10000.0) / 10000L;
        return distance;
    }

    public static Map<String, String> getAround(double lng, double lat, double raidusMile) {
        HashMap<String, String> map = new HashMap<String, String>();
        Double degree = 111293.63611111112;
        Double mpdLng = Double.parseDouble((degree * Math.cos(lng * (Math.PI / 180)) + "").replace("-", ""));
        Double dpmLng = 1.0 / mpdLng;
        Double radiusLng = dpmLng * raidusMile;
        Double minLat = lat - radiusLng;
        Double maxLat = lat + radiusLng;
        Double dpmLat = 1.0 / degree;
        Double radiusLat = dpmLat * raidusMile;
        Double minLng = lng - radiusLat;
        Double maxLng = lng + radiusLat;
        map.put("minLat", minLat + "");
        map.put("maxLat", maxLat + "");
        map.put("minLng", minLng + "");
        map.put("maxLng", maxLng + "");
        return map;
    }
}

