/*
 * Decompiled with CFR 0.152.
 */
package com.github.fartherp.framework.common.util;

import com.dyuproject.protostuff.LinkedBuffer;
import com.dyuproject.protostuff.ProtobufIOUtil;
import com.dyuproject.protostuff.Schema;
import com.dyuproject.protostuff.runtime.IdStrategy;
import com.dyuproject.protostuff.runtime.RuntimeEnv;
import com.dyuproject.protostuff.runtime.RuntimeSchema;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.objenesis.Objenesis;
import org.objenesis.ObjenesisStd;

public class ProtobufSerializeUtil {
    private static final Map<String, Schema<?>> cachedSchema = new ConcurrentHashMap();
    private static final Objenesis objenesis = new ObjenesisStd(true);
    private static final Log logger = LogFactory.getLog(ProtobufSerializeUtil.class);

    public static <T> byte[] serialize(T obj) {
        return ProtobufSerializeUtil.serialization(obj, null, null);
    }

    public static <T> byte[] serialize(T obj, String[] inclusives) {
        return ProtobufSerializeUtil.serialization(obj, null, inclusives);
    }

    public static <T> byte[] serializeWithExclusions(T obj, String[] exclusions) {
        return ProtobufSerializeUtil.serialization(obj, exclusions, null);
    }

    public static <T> T deserialize(byte[] data, Class<T> cls) {
        return ProtobufSerializeUtil.deserialization(data, cls, null, null);
    }

    public static <T> T deserialize(byte[] data, Class<T> cls, String[] fields) {
        return ProtobufSerializeUtil.deserialization(data, cls, null, fields);
    }

    public static <T> T deserializeWithExclusions(byte[] data, Class<T> cls, String[] fields) {
        return ProtobufSerializeUtil.deserialization(data, cls, fields, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> byte[] serialization(T obj, String[] exclusions, String[] inclusives) {
        if (null == obj) {
            return null;
        }
        Class<?> cls = obj.getClass();
        LinkedBuffer buffer = LinkedBuffer.allocate((int)512);
        try {
            Schema<?> schema = ProtobufSerializeUtil.initSchema(exclusions, inclusives, cls);
            byte[] byArray = ProtobufIOUtil.toByteArray(obj, schema, (LinkedBuffer)buffer);
            return byArray;
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            buffer.clear();
        }
        return null;
    }

    private static <T> Schema<T> initSchema(String[] exclusions, String[] inclusives, Class<T> cls) {
        if (null != exclusions && exclusions.length != 0) {
            return ProtobufSerializeUtil.getSchemaWithExclusion(cls, exclusions);
        }
        if (null != inclusives && inclusives.length != 0) {
            return ProtobufSerializeUtil.getSchemaWithInclusive(cls, inclusives);
        }
        return ProtobufSerializeUtil.getSchema(cls);
    }

    private static <T> T deserialization(byte[] data, Class<T> cls, String[] exclusions, String[] inclusives) {
        if (data == null || data.length == 0) {
            return null;
        }
        try {
            Object message = objenesis.newInstance(cls);
            Schema<T> schema = ProtobufSerializeUtil.initSchema(exclusions, inclusives, cls);
            ProtobufIOUtil.mergeFrom((byte[])data, (Object)message, schema);
            return (T)message;
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private static String getKey(Class cls) {
        List<String> sorts = ProtobufSerializeUtil.getSortedFields(cls);
        return cls.getName() + sorts.toString();
    }

    private static String getKeyWithExclusion(Class cls, String[] fields) {
        List<String> sorts = ProtobufSerializeUtil.getSortedFields(cls);
        List<String> exclusions = Arrays.asList(fields);
        sorts.removeAll(exclusions);
        return cls.getName() + sorts.toString();
    }

    private static String getKeyWithInclusion(Class cls, String[] fields) {
        List<String> l = Arrays.asList(fields);
        return cls.getName() + l.toString();
    }

    private static List<String> getSortedFields(Class cls) {
        Field[] fields = cls.getDeclaredFields();
        Object[] strs = new String[fields.length];
        int i = 0;
        for (Field field : fields) {
            strs[i] = field.getName();
            ++i;
        }
        Arrays.sort(strs);
        return new ArrayList<Object>(Arrays.asList(strs));
    }

    private static <T> Schema<T> getSchema(Class<T> cls) {
        String key = ProtobufSerializeUtil.getKey(cls);
        RuntimeSchema schema = cachedSchema.get(key);
        if (schema == null) {
            schema = RuntimeSchema.createFrom(cls);
            cachedSchema.put(key, (Schema<?>)schema);
        }
        return schema;
    }

    private static <T> Schema<T> getSchemaWithExclusion(Class<T> cls, String[] fields) {
        String key = ProtobufSerializeUtil.getKeyWithExclusion(cls, fields);
        RuntimeSchema schema = cachedSchema.get(key);
        if (schema == null) {
            schema = RuntimeSchema.createFrom(cls, (String[])fields, (IdStrategy)RuntimeEnv.ID_STRATEGY);
            cachedSchema.put(key, (Schema<?>)schema);
        }
        return schema;
    }

    private static <T> Schema<T> getSchemaWithInclusive(Class<T> cls, String[] fields) {
        String key = ProtobufSerializeUtil.getKeyWithInclusion(cls, fields);
        RuntimeSchema schema = cachedSchema.get(key);
        if (schema == null) {
            LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
            for (String field : fields) {
                map.put(field, field);
            }
            schema = RuntimeSchema.createFrom(cls, map, (IdStrategy)RuntimeEnv.ID_STRATEGY);
            cachedSchema.put(key, (Schema<?>)schema);
        }
        return schema;
    }
}

