/*
 * Decompiled with CFR 0.152.
 */
package com.github.fartherp.framework.common.util;

import com.github.fartherp.framework.common.util.UserAgent;
import org.apache.commons.lang3.StringUtils;

public class UserAgentUtil {
    public static final String PLATFORM_WINDOWS = "Windows";
    public static final String BROWSER_IE = "Internet Explorer";
    public static final String BROWSER_CHROME = "Chrome";
    public static final String BROWSER_FIREFOX = "Firefox";

    public static UserAgent getUserAgent(String userAgentStr) {
        if (StringUtils.isBlank((CharSequence)userAgentStr)) {
            return null;
        }
        if (userAgentStr.contains(PLATFORM_WINDOWS)) {
            if (userAgentStr.contains("Windows NT 6.2")) {
                return UserAgentUtil.judgeBrowser(userAgentStr, PLATFORM_WINDOWS, "8", null);
            }
            if (userAgentStr.contains("Windows NT 6.1")) {
                return UserAgentUtil.judgeBrowser(userAgentStr, PLATFORM_WINDOWS, "7", null);
            }
            if (userAgentStr.contains("Windows NT 6.0")) {
                return UserAgentUtil.judgeBrowser(userAgentStr, PLATFORM_WINDOWS, "Vista", null);
            }
            if (userAgentStr.contains("Windows NT 5.2")) {
                return UserAgentUtil.judgeBrowser(userAgentStr, PLATFORM_WINDOWS, "XP", "x64 Edition");
            }
            if (userAgentStr.contains("Windows NT 5.1")) {
                return UserAgentUtil.judgeBrowser(userAgentStr, PLATFORM_WINDOWS, "XP", null);
            }
            if (userAgentStr.contains("Windows NT 5.01")) {
                return UserAgentUtil.judgeBrowser(userAgentStr, PLATFORM_WINDOWS, "2000", "SP1");
            }
            if (userAgentStr.contains("Windows NT 5.0")) {
                return UserAgentUtil.judgeBrowser(userAgentStr, PLATFORM_WINDOWS, "2000", null);
            }
            if (userAgentStr.contains("Windows NT 4.0")) {
                return UserAgentUtil.judgeBrowser(userAgentStr, PLATFORM_WINDOWS, "NT 4.0", null);
            }
            if (userAgentStr.contains("Windows 98; Win 9x 4.90")) {
                return UserAgentUtil.judgeBrowser(userAgentStr, PLATFORM_WINDOWS, "ME", null);
            }
            if (userAgentStr.contains("Windows 98")) {
                return UserAgentUtil.judgeBrowser(userAgentStr, PLATFORM_WINDOWS, "98", null);
            }
            if (userAgentStr.contains("Windows 95")) {
                return UserAgentUtil.judgeBrowser(userAgentStr, PLATFORM_WINDOWS, "95", null);
            }
            if (userAgentStr.contains("Windows CE")) {
                return UserAgentUtil.judgeBrowser(userAgentStr, PLATFORM_WINDOWS, "CE", null);
            }
            return UserAgentUtil.judgeBrowser(userAgentStr, PLATFORM_WINDOWS, null, null);
        }
        if (userAgentStr.contains("Mac OS X")) {
            if (userAgentStr.contains("iPod")) {
                return UserAgentUtil.judgeBrowser(userAgentStr, "iPod", null, null);
            }
            if (userAgentStr.contains("iPhone")) {
                return UserAgentUtil.judgeBrowser(userAgentStr, "iPhone", null, null);
            }
            if (userAgentStr.contains("Macintosh")) {
                return UserAgentUtil.judgeBrowser(userAgentStr, "Macintosh", null, null);
            }
            return UserAgentUtil.judgeBrowser(userAgentStr, "Mac OS X", null, null);
        }
        return null;
    }

    private static UserAgent judgeBrowser(String userAgentStr, String platformType, String platformSeries, String platformVersion) {
        if (userAgentStr.contains(BROWSER_CHROME)) {
            String temp = userAgentStr.substring(userAgentStr.indexOf("Chrome/") + 7);
            String chromeVersion = null;
            chromeVersion = !temp.contains(" ") ? temp : temp.substring(0, temp.indexOf(" "));
            return new UserAgent(BROWSER_CHROME, chromeVersion, platformType, platformSeries, platformVersion);
        }
        if (userAgentStr.contains(BROWSER_FIREFOX)) {
            String temp = userAgentStr.substring(userAgentStr.indexOf("Firefox/") + 8);
            String ffVersion = null;
            ffVersion = !temp.contains(" ") ? temp : temp.substring(0, temp.indexOf(" "));
            return new UserAgent(BROWSER_FIREFOX, ffVersion, platformType, platformSeries, platformVersion);
        }
        if (userAgentStr.contains("MSIE")) {
            if (userAgentStr.contains("MSIE 10.0")) {
                return new UserAgent(BROWSER_IE, "10", platformType, platformSeries, platformVersion);
            }
            if (userAgentStr.contains("MSIE 9.0")) {
                return new UserAgent(BROWSER_IE, "9", platformType, platformSeries, platformVersion);
            }
            if (userAgentStr.contains("MSIE 8.0")) {
                return new UserAgent(BROWSER_IE, "8", platformType, platformSeries, platformVersion);
            }
            if (userAgentStr.contains("MSIE 7.0")) {
                return new UserAgent(BROWSER_IE, "7", platformType, platformSeries, platformVersion);
            }
            if (userAgentStr.contains("MSIE 6.0")) {
                return new UserAgent(BROWSER_IE, "6", platformType, platformSeries, platformVersion);
            }
        } else {
            return new UserAgent(null, null, platformType, platformSeries, platformVersion);
        }
        return null;
    }
}

