/*
 * Decompiled with CFR 0.152.
 */
package com.github.fartherp.framework.common.code;

import com.github.fartherp.framework.common.code.ASCII;
import com.github.fartherp.framework.common.code.EBCDIC;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;

public class Coder {
    public static int ASCIIToEBCDIC(int ascii) {
        return ASCII.AToE[ascii & 0xFF] & 0xFF;
    }

    public static int EBCDICToASCII(int ebcdic) {
        return EBCDIC.EToA[ebcdic & 0xFF] & 0xFF;
    }

    public static byte[] ASCIIToEBCDIC(byte[] ascii) {
        byte[] tobytes = new byte[ascii.length];
        for (int i = 0; i < ascii.length; ++i) {
            tobytes[i] = (byte)Coder.ASCIIToEBCDIC(ascii[i]);
        }
        return tobytes;
    }

    public static byte[] EBCDICToASCII(byte[] ebcdic) {
        byte[] tobytes = new byte[ebcdic.length];
        for (int i = 0; i < ebcdic.length; ++i) {
            tobytes[i] = (byte)Coder.EBCDICToASCII(ebcdic[i]);
        }
        return tobytes;
    }

    public static String ASCIIToEBCDIC(String ascii) {
        return new String(Coder.ASCIIToEBCDIC(ascii.getBytes()));
    }

    public static String EBCDICToASCII(String ebcdic) {
        return new String(Coder.EBCDICToASCII(ebcdic.getBytes()));
    }

    public static void ASCIIToEBCDIC(String fromFile, String toFile) {
        try {
            int tempint;
            FileInputStream in = new FileInputStream(new File(fromFile));
            FileOutputStream out = new FileOutputStream(new File(toFile));
            int i = 0;
            byte[] tempbytes = new byte[in.available()];
            while ((tempint = in.read()) != -1) {
                tempbytes[i++] = (byte)tempint;
            }
            out.write(Coder.ASCIIToEBCDIC(tempbytes));
            in.close();
            out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void EBCDICToASCII(String fromFile, String toFile) {
        try {
            int temp;
            FileInputStream in = new FileInputStream(new File(fromFile));
            FileOutputStream out = new FileOutputStream(new File(toFile));
            int i = 0;
            byte[] bytes = new byte[in.available()];
            while ((temp = in.read()) != -1) {
                bytes[i++] = (byte)temp;
            }
            out.write(Coder.EBCDICToASCII(bytes));
            in.close();
            out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

