/*
 * Decompiled with CFR 0.152.
 */
package com.github.fartherp.framework.common.util;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;

public class DbManager {
    private String driveName = "com.mysql.jdbc.Driver";
    private String url;
    private String user;
    private String password;

    public DbManager() {
    }

    public DbManager(String url, String user, String password) {
        this.url = url;
        this.user = user;
        this.password = password;
    }

    public Connection getConnection() {
        try {
            Class.forName(this.driveName);
            return DriverManager.getConnection(this.url, this.user, this.password);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("load database class exception : " + e.getMessage(), e);
        }
        catch (SQLException e) {
            throw new RuntimeException("get database connection : " + e.getMessage(), e);
        }
    }

    public PreparedStatement getPreparedStatement(Connection connection, String sql) {
        try {
            return connection.prepareStatement(sql);
        }
        catch (SQLException e) {
            throw new RuntimeException("get PrepareStatement exception : " + e.getMessage(), e);
        }
    }

    public ResultSet getResultSet(PreparedStatement preparedStatement) {
        try {
            return preparedStatement.executeQuery();
        }
        catch (SQLException e) {
            throw new RuntimeException("get ResultSet exception : " + e.getMessage(), e);
        }
    }

    public ResultSet getTables(Connection connection, String localCatalog, String localSchema, String localTableName) {
        try {
            return this.getDatabaseMetaData(connection).getTables(localCatalog, localSchema, localTableName, null);
        }
        catch (SQLException e) {
            throw new RuntimeException("get tables exception : " + e.getMessage(), e);
        }
    }

    public ResultSet getColumns(Connection connection, String localCatalog, String localSchema, String localTableName) {
        try {
            return this.getDatabaseMetaData(connection).getColumns(localCatalog, localSchema, localTableName, null);
        }
        catch (SQLException e) {
            throw new RuntimeException("get columns exception : " + e.getMessage(), e);
        }
    }

    public ResultSet getPrimaryKeys(Connection connection, String localCatalog, String localSchema, String localTableName) {
        try {
            return this.getDatabaseMetaData(connection).getPrimaryKeys(localCatalog, localSchema, localTableName);
        }
        catch (SQLException e) {
            throw new RuntimeException("get primary key exception : " + e.getMessage(), e);
        }
    }

    public ResultSetMetaData getResultSetMetaData(ResultSet resultSet) {
        try {
            return resultSet.getMetaData();
        }
        catch (SQLException e) {
            throw new RuntimeException("get ResultSetMetaData exception : " + e.getMessage(), e);
        }
    }

    public DatabaseMetaData getDatabaseMetaData(Connection connection) {
        try {
            return connection.getMetaData();
        }
        catch (SQLException e) {
            throw new RuntimeException("get DatabaseMetaData exception : " + e.getMessage(), e);
        }
    }

    public void close(Connection connection, PreparedStatement preparedStatement, ResultSet resultSet) {
        if (null != resultSet) {
            try {
                resultSet.close();
            }
            catch (SQLException e) {
                resultSet = null;
            }
        }
        if (null != preparedStatement) {
            try {
                preparedStatement.close();
            }
            catch (SQLException e) {
                preparedStatement = null;
            }
        }
        if (null != connection) {
            try {
                connection.close();
            }
            catch (SQLException e) {
                connection = null;
            }
        }
    }

    public void close(Connection connection) {
        this.close(connection, null, null);
    }

    public void close(PreparedStatement preparedStatement) {
        this.close(null, preparedStatement, null);
    }

    public void close(ResultSet resultSet) {
        this.close(null, null, resultSet);
    }

    public String getDriveName() {
        return this.driveName;
    }

    public void setDriveName(String driveName) {
        this.driveName = driveName;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }
}

