/*
 * Decompiled with CFR 0.152.
 */
package com.github.fartherp.framework.common.util;

import com.github.fartherp.framework.common.util.UserAgent;
import com.github.fartherp.framework.common.util.UserAgentUtil;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;

public class FileUtilies {
    public static File getDirectory(String targetPackage, String fileName, String dir) {
        File project = new File(dir);
        if (!project.isDirectory()) {
            throw new RuntimeException("[" + project + "] is not directory ");
        }
        StringBuilder sb = new StringBuilder();
        StringTokenizer st = new StringTokenizer(targetPackage, ".");
        while (st.hasMoreTokens()) {
            sb.append(st.nextToken());
            sb.append(File.separatorChar);
        }
        File directory = new File(project, sb.toString());
        if (!directory.isDirectory() && !directory.mkdirs()) {
            throw new RuntimeException("[" + directory + "] file create fail");
        }
        return new File(directory, fileName);
    }

    public static void writeFile(File file, String content) {
        FileUtilies.writeFile(file, content, "UTF-8");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeFile(File file, String content, String fileEncoding) {
        BufferedWriter bw = null;
        try {
            FileOutputStream fos = new FileOutputStream(file, false);
            OutputStreamWriter osw = fileEncoding == null ? new OutputStreamWriter(fos) : new OutputStreamWriter((OutputStream)fos, fileEncoding);
            bw = new BufferedWriter(osw);
            bw.write(content);
        }
        catch (IOException iOException) {
        }
        finally {
            if (bw != null) {
                try {
                    bw.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static String getFileName(String fileName, HttpServletRequest request) {
        try {
            UserAgent userAgent = UserAgentUtil.getUserAgent(request.getHeader("USER-AGENT"));
            if (userAgent != null && "Firefox".equals(userAgent.getBrowserType())) {
                return new String(fileName.getBytes(StandardCharsets.UTF_8), StandardCharsets.ISO_8859_1);
            }
            return URLEncoder.encode(fileName, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("charset no support UTF-8", e);
        }
    }
}

