/*
 * Decompiled with CFR 0.152.
 */
package com.github.fartherp.framework.common.util;

import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Random;
import java.util.StringTokenizer;

public class ISOUtil {
    public static final String[] hexStrings = new String[256];
    public static final String ENCODING = "ISO8859_1";
    public static final Charset CHARSET;
    public static final byte[] EBCDIC2ASCII;
    public static final byte[] ASCII2EBCDIC;
    public static final byte STX = 2;
    public static final byte FS = 28;
    public static final byte US = 31;
    public static final byte RS = 29;
    public static final byte GS = 30;
    public static final byte ETX = 3;

    public static String ebcdicToAscii(byte[] e) {
        return new String(ISOUtil.ebcdicToAsciiBytes(e, 0, e.length), CHARSET);
    }

    public static String ebcdicToAscii(byte[] e, int offset, int len) {
        return new String(ISOUtil.ebcdicToAsciiBytes(e, offset, len), CHARSET);
    }

    public static byte[] ebcdicToAsciiBytes(byte[] e) {
        return ISOUtil.ebcdicToAsciiBytes(e, 0, e.length);
    }

    public static byte[] ebcdicToAsciiBytes(byte[] e, int offset, int len) {
        byte[] a = new byte[len];
        for (int i = 0; i < len; ++i) {
            a[i] = EBCDIC2ASCII[e[offset + i] & 0xFF];
        }
        return a;
    }

    public static byte[] asciiToEbcdic(String s) {
        int len = s.length();
        byte[] b = new byte[len];
        for (int i = 0; i < len; ++i) {
            b[i] = ASCII2EBCDIC[s.charAt(i) & 0xFF];
        }
        return b;
    }

    public static byte[] asciiToEbcdic(byte[] a) {
        byte[] e = new byte[a.length];
        for (int i = 0; i < a.length; ++i) {
            e[i] = ASCII2EBCDIC[a[i] & 0xFF];
        }
        return e;
    }

    public static void asciiToEbcdic(String s, byte[] e, int offset) {
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            e[offset + i] = ASCII2EBCDIC[s.charAt(i) & 0xFF];
        }
    }

    public static void asciiToEbcdic(byte[] s, byte[] e, int offset) {
        int len = s.length;
        for (int i = 0; i < len; ++i) {
            e[offset + i] = ASCII2EBCDIC[s[i]];
        }
    }

    public static String padleft(String s, int len, char c) throws RuntimeException {
        if ((s = s.trim()).length() > len) {
            throw new RuntimeException("invalid len " + s.length() + "/" + len);
        }
        StringBuilder d = new StringBuilder(len);
        int fill = len - s.length();
        while (fill-- > 0) {
            d.append(c);
        }
        d.append(s);
        return d.toString();
    }

    public static String padright(String s, int len, char c) throws RuntimeException {
        if ((s = s.trim()).length() > len) {
            throw new RuntimeException("invalid len " + s.length() + "/" + len);
        }
        StringBuilder d = new StringBuilder(len);
        int fill = len - s.length();
        d.append(s);
        while (fill-- > 0) {
            d.append(c);
        }
        return d.toString();
    }

    public static String trim(String s) {
        return s != null ? s.trim() : null;
    }

    public static String zeropad(String s, int len) throws RuntimeException {
        return ISOUtil.padleft(s, len, '0');
    }

    public static String zeropad(long l, int len) {
        try {
            return ISOUtil.padleft(Long.toString((long)((double)l % Math.pow(10.0, len))), len, '0');
        }
        catch (RuntimeException runtimeException) {
            return null;
        }
    }

    public static String strpad(String s, int len) {
        StringBuilder d = new StringBuilder(s);
        while (d.length() < len) {
            d.append(' ');
        }
        return d.toString();
    }

    public static String zeropadRight(String s, int len) {
        StringBuilder d = new StringBuilder(s);
        while (d.length() < len) {
            d.append('0');
        }
        return d.toString();
    }

    public static byte[] str2bcd(String s, boolean padLeft, byte[] d, int offset) {
        int start;
        int len;
        for (int i = start = ((len = s.length()) & 1) == 1 && padLeft ? 1 : 0; i < len + start; ++i) {
            int n = offset + (i >> 1);
            d[n] = (byte)(d[n] | s.charAt(i - start) - 48 << ((i & 1) == 1 ? 0 : 4));
        }
        return d;
    }

    public static byte[] str2bcd(String s, boolean padLeft) {
        int len = s.length();
        byte[] d = new byte[len + 1 >> 1];
        return ISOUtil.str2bcd(s, padLeft, d, 0);
    }

    public static byte[] str2bcd(String s, boolean padLeft, byte fill) {
        int start;
        int len = s.length();
        byte[] d = new byte[len + 1 >> 1];
        Arrays.fill(d, fill);
        for (int i = start = (len & 1) == 1 && padLeft ? 1 : 0; i < len + start; ++i) {
            int n = i >> 1;
            d[n] = (byte)(d[n] | s.charAt(i - start) - 48 << ((i & 1) == 1 ? 0 : 4));
        }
        return d;
    }

    public static String bcd2str(byte[] b, int offset, int len, boolean padLeft) {
        int start;
        StringBuilder d = new StringBuilder(len);
        for (int i = start = (len & 1) == 1 && padLeft ? 1 : 0; i < len + start; ++i) {
            int shift = (i & 1) == 1 ? 0 : 4;
            char c = Character.forDigit(b[offset + (i >> 1)] >> shift & 0xF, 16);
            if (c == 'd') {
                c = '=';
            }
            d.append(Character.toUpperCase(c));
        }
        return d.toString();
    }

    public static String hexString(byte[] b) {
        StringBuilder d = new StringBuilder(b.length * 2);
        for (byte aB : b) {
            d.append(hexStrings[aB & 0xFF]);
        }
        return d.toString();
    }

    public static String dumpString(byte[] b) {
        StringBuilder d = new StringBuilder(b.length * 2);
        for (byte aB : b) {
            char c = (char)aB;
            if (Character.isISOControl(c)) {
                switch (c) {
                    case '\r': {
                        d.append("{CR}");
                        break;
                    }
                    case '\n': {
                        d.append("{LF}");
                        break;
                    }
                    case '\u0000': {
                        d.append("{NULL}");
                        break;
                    }
                    case '\u0001': {
                        d.append("{SOH}");
                        break;
                    }
                    case '\u0002': {
                        d.append("{STX}");
                        break;
                    }
                    case '\u0003': {
                        d.append("{ETX}");
                        break;
                    }
                    case '\u0004': {
                        d.append("{EOT}");
                        break;
                    }
                    case '\u0005': {
                        d.append("{ENQ}");
                        break;
                    }
                    case '\u0006': {
                        d.append("{ACK}");
                        break;
                    }
                    case '\u0007': {
                        d.append("{BEL}");
                        break;
                    }
                    case '\u0010': {
                        d.append("{DLE}");
                        break;
                    }
                    case '\u0015': {
                        d.append("{NAK}");
                        break;
                    }
                    case '\u0016': {
                        d.append("{SYN}");
                        break;
                    }
                    case '\u001c': {
                        d.append("{FS}");
                        break;
                    }
                    case '\u001e': {
                        d.append("{RS}");
                        break;
                    }
                    default: {
                        d.append('[');
                        d.append(hexStrings[aB & 0xFF]);
                        d.append(']');
                        break;
                    }
                }
                continue;
            }
            d.append(c);
        }
        return d.toString();
    }

    public static String hexString(byte[] b, int offset, int len) {
        StringBuilder d = new StringBuilder(len * 2);
        len += offset;
        for (int i = offset; i < len; ++i) {
            d.append(hexStrings[b[i] & 0xFF]);
        }
        return d.toString();
    }

    public static String bitSet2String(BitSet b) {
        int len = b.size();
        len = len > 128 ? 128 : len;
        StringBuilder d = new StringBuilder(len);
        for (int i = 0; i < len; ++i) {
            d.append(b.get(i) ? (char)'1' : '0');
        }
        return d.toString();
    }

    public static byte[] bitSet2byte(BitSet b) {
        int len = b.length() + 62 >> 6 << 6;
        byte[] d = new byte[len >> 3];
        for (int i = 0; i < len; ++i) {
            if (!b.get(i + 1)) continue;
            int n = i >> 3;
            d[n] = (byte)(d[n] | 128 >> i % 8);
        }
        if (len > 64) {
            d[0] = (byte)(d[0] | 0x80);
        }
        if (len > 128) {
            d[8] = (byte)(d[8] | 0x80);
        }
        return d;
    }

    public static byte[] bitSet2byte(BitSet b, int bytes) {
        int len = bytes * 8;
        byte[] d = new byte[bytes];
        for (int i = 0; i < len; ++i) {
            if (!b.get(i + 1)) continue;
            int n = i >> 3;
            d[n] = (byte)(d[n] | 128 >> i % 8);
        }
        if (len > 64) {
            d[0] = (byte)(d[0] | 0x80);
        }
        if (len > 128) {
            d[8] = (byte)(d[8] | 0x80);
        }
        return d;
    }

    public static int bitSet2Int(BitSet bs) {
        int total = 0;
        int b = bs.length() - 1;
        if (b > 0) {
            int value = (int)Math.pow(2.0, b);
            for (int i = 0; i <= b; ++i) {
                if (bs.get(i)) {
                    total += value;
                }
                value >>= 1;
            }
        }
        return total;
    }

    public static BitSet int2BitSet(int value) {
        return ISOUtil.int2BitSet(value, 0);
    }

    public static BitSet int2BitSet(int value, int offset) {
        BitSet bs = new BitSet();
        String hex = Integer.toHexString(value);
        ISOUtil.hex2BitSet(bs, hex.getBytes(), offset);
        return bs;
    }

    public static BitSet byte2BitSet(byte[] b, int offset, boolean bitZeroMeansExtended) {
        int len = bitZeroMeansExtended ? ((b[offset] & 0x80) == 128 ? 128 : 64) : 64;
        BitSet bmap = new BitSet(len);
        for (int i = 0; i < len; ++i) {
            if ((b[offset + (i >> 3)] & 128 >> i % 8) <= 0) continue;
            bmap.set(i + 1);
        }
        return bmap;
    }

    public static BitSet byte2BitSet(byte[] b, int offset, int maxBits) {
        int len;
        int n = maxBits > 64 ? ((b[offset] & 0x80) == 128 ? 128 : 64) : (len = maxBits);
        if (maxBits > 128 && b.length > offset + 8 && (b[offset + 8] & 0x80) == 128) {
            len = 192;
        }
        BitSet bmap = new BitSet(len);
        for (int i = 0; i < len; ++i) {
            if ((b[offset + (i >> 3)] & 128 >> i % 8) <= 0) continue;
            bmap.set(i + 1);
        }
        return bmap;
    }

    public static BitSet byte2BitSet(BitSet bmap, byte[] b, int bitOffset) {
        int len = b.length << 3;
        for (int i = 0; i < len; ++i) {
            if ((b[i >> 3] & 128 >> i % 8) <= 0) continue;
            bmap.set(bitOffset + i + 1);
        }
        return bmap;
    }

    public static BitSet hex2BitSet(byte[] b, int offset, boolean bitZeroMeansExtended) {
        int len = bitZeroMeansExtended ? ((Character.digit((char)b[offset], 16) & 8) == 8 ? 128 : 64) : 64;
        BitSet bmap = new BitSet(len);
        for (int i = 0; i < len; ++i) {
            int digit = Character.digit((char)b[offset + (i >> 2)], 16);
            if ((digit & 8 >> i % 4) <= 0) continue;
            bmap.set(i + 1);
        }
        return bmap;
    }

    public static BitSet hex2BitSet(byte[] b, int offset, int maxBits) {
        int len;
        int n = maxBits > 64 ? ((Character.digit((char)b[offset], 16) & 8) == 8 ? 128 : 64) : (len = maxBits);
        if (len > 64 && maxBits > 128 && b.length > offset + 16 && (Character.digit((char)b[offset + 16], 16) & 8) == 8) {
            len = 192;
        }
        BitSet bmap = new BitSet(len);
        for (int i = 0; i < len; ++i) {
            int digit = Character.digit((char)b[offset + (i >> 2)], 16);
            if ((digit & 8 >> i % 4) <= 0) continue;
            bmap.set(i + 1);
            if (i != 65 || maxBits <= 128) continue;
            len = 192;
        }
        return bmap;
    }

    public static BitSet hex2BitSet(BitSet bmap, byte[] b, int bitOffset) {
        int len = b.length << 2;
        for (int i = 0; i < len; ++i) {
            int digit = Character.digit((char)b[i >> 2], 16);
            if ((digit & 8 >> i % 4) <= 0) continue;
            bmap.set(bitOffset + i + 1);
        }
        return bmap;
    }

    public static byte[] hex2byte(byte[] b, int offset, int len) {
        byte[] d = new byte[len];
        for (int i = 0; i < len * 2; ++i) {
            int shift = i % 2 == 1 ? 0 : 4;
            int n = i >> 1;
            d[n] = (byte)(d[n] | Character.digit((char)b[offset + i], 16) << shift);
        }
        return d;
    }

    public static byte[] hex2byte(String s) {
        if (s.length() % 2 == 0) {
            return ISOUtil.hex2byte(s.getBytes(), 0, s.length() >> 1);
        }
        return ISOUtil.hex2byte("0" + s);
    }

    public static String byte2hex(byte[] bs) {
        return ISOUtil.byte2hex(bs, 0, bs.length);
    }

    public static byte[] int2byte(int value) {
        if (value < 0) {
            return new byte[]{(byte)(value >>> 24 & 0xFF), (byte)(value >>> 16 & 0xFF), (byte)(value >>> 8 & 0xFF), (byte)(value & 0xFF)};
        }
        if (value <= 255) {
            return new byte[]{(byte)(value & 0xFF)};
        }
        if (value <= 65535) {
            return new byte[]{(byte)(value >>> 8 & 0xFF), (byte)(value & 0xFF)};
        }
        if (value <= 0xFFFFFF) {
            return new byte[]{(byte)(value >>> 16 & 0xFF), (byte)(value >>> 8 & 0xFF), (byte)(value & 0xFF)};
        }
        return new byte[]{(byte)(value >>> 24 & 0xFF), (byte)(value >>> 16 & 0xFF), (byte)(value >>> 8 & 0xFF), (byte)(value & 0xFF)};
    }

    public static int byte2int(byte[] bytes) {
        int i;
        if (bytes == null || bytes.length == 0) {
            return 0;
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate(4);
        for (i = 0; i < 4 - bytes.length; ++i) {
            byteBuffer.put((byte)0);
        }
        for (i = 0; i < bytes.length; ++i) {
            byteBuffer.put(bytes[i]);
        }
        byteBuffer.position(0);
        return byteBuffer.getInt();
    }

    public static String byte2hex(byte[] bs, int off, int length) {
        if (bs.length <= off || bs.length < off + length) {
            throw new IllegalArgumentException();
        }
        StringBuilder sb = new StringBuilder(length * 2);
        ISOUtil.byte2hexAppend(bs, off, length, sb);
        return sb.toString();
    }

    private static void byte2hexAppend(byte[] bs, int off, int length, StringBuilder sb) {
        if (bs.length <= off || bs.length < off + length) {
            throw new IllegalArgumentException();
        }
        sb.ensureCapacity(sb.length() + length * 2);
        for (int i = off; i < off + length; ++i) {
            sb.append(Character.forDigit(bs[i] >>> 4 & 0xF, 16));
            sb.append(Character.forDigit(bs[i] & 0xF, 16));
        }
    }

    public static String formatDouble(double d, int len) {
        String prefix = Long.toString((long)d);
        String suffix = Integer.toString((int)(Math.round(d * 100.0) % 100L));
        try {
            if (len > 3) {
                prefix = ISOUtil.padleft(prefix, len - 3, ' ');
            }
            suffix = ISOUtil.zeropad(suffix, 2);
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        return prefix + "." + suffix;
    }

    public static String formatAmount(long l, int len) throws RuntimeException {
        String buf = Long.toString(l);
        if (l < 100L) {
            buf = ISOUtil.zeropad(buf, 3);
        }
        StringBuilder s = new StringBuilder(ISOUtil.padleft(buf, len - 1, ' '));
        s.insert(len - 3, '.');
        return s.toString();
    }

    public static String normalize(String s, boolean canonical) {
        StringBuilder str = new StringBuilder();
        int len = s != null ? s.length() : 0;
        block7: for (int i = 0; i < len; ++i) {
            char ch = s.charAt(i);
            switch (ch) {
                case '<': {
                    str.append("&lt;");
                    continue block7;
                }
                case '>': {
                    str.append("&gt;");
                    continue block7;
                }
                case '&': {
                    str.append("&amp;");
                    continue block7;
                }
                case '\"': {
                    str.append("&quot;");
                    continue block7;
                }
                case '\n': 
                case '\r': {
                    if (canonical) {
                        str.append("&#");
                        str.append(Integer.toString(ch & 0xFF));
                        str.append(';');
                        continue block7;
                    }
                }
                default: {
                    if (ch < ' ') {
                        str.append("&#");
                        str.append(Integer.toString(ch & 0xFF));
                        str.append(';');
                        continue block7;
                    }
                    if (ch > '\uff00') {
                        str.append((char)(ch & 0xFF));
                        continue block7;
                    }
                    str.append(ch);
                }
            }
        }
        return str.toString();
    }

    public static String normalize(String s) {
        return ISOUtil.normalize(s, true);
    }

    public static String protect(String s) {
        StringBuilder sb = new StringBuilder();
        int len = s.length();
        int clear = len > 6 ? 6 : 0;
        int lastFourIndex = -1;
        if (clear > 0) {
            lastFourIndex = s.indexOf(61) - 4;
            if (lastFourIndex < 0) {
                lastFourIndex = s.indexOf(94) - 4;
            }
            if (lastFourIndex < 0 && s.indexOf(94) < 0) {
                lastFourIndex = s.indexOf(68) - 4;
            }
            if (lastFourIndex < 0) {
                lastFourIndex = len - 4;
            }
        }
        for (int i = 0; i < len; ++i) {
            if (s.charAt(i) == '=' || s.charAt(i) == 'D' && s.indexOf(94) < 0) {
                clear = 1;
            } else if (s.charAt(i) == '^') {
                lastFourIndex = 0;
                clear = len - i;
            } else if (i == lastFourIndex) {
                clear = 4;
            }
            sb.append(clear-- > 0 ? s.charAt(i) : (char)'_');
        }
        s = sb.toString();
        try {
            int charCount = s.replaceAll("[^\\^]", "").length();
            if (charCount == 2) {
                s = s.substring(0, s.lastIndexOf("^") + 1);
                s = ISOUtil.padright(s, len, '_');
            }
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        return s;
    }

    public static int[] toIntArray(String s) {
        StringTokenizer st = new StringTokenizer(s);
        int[] array = new int[st.countTokens()];
        int i = 0;
        while (st.hasMoreTokens()) {
            array[i] = Integer.parseInt(st.nextToken());
            ++i;
        }
        return array;
    }

    public static String[] toStringArray(String s) {
        StringTokenizer st = new StringTokenizer(s);
        String[] array = new String[st.countTokens()];
        int i = 0;
        while (st.hasMoreTokens()) {
            array[i] = st.nextToken();
            ++i;
        }
        return array;
    }

    public static byte[] xor(byte[] op1, byte[] op2) {
        byte[] result = op2.length > op1.length ? new byte[op1.length] : new byte[op2.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = (byte)(op1[i] ^ op2[i]);
        }
        return result;
    }

    public static String hexor(String op1, String op2) {
        byte[] xor = ISOUtil.xor(ISOUtil.hex2byte(op1), ISOUtil.hex2byte(op2));
        return ISOUtil.hexString(xor);
    }

    public static byte[] trim(byte[] array, int length) {
        byte[] trimmedArray = new byte[length];
        System.arraycopy(array, 0, trimmedArray, 0, length);
        return trimmedArray;
    }

    public static byte[] concat(byte[] array1, byte[] array2) {
        byte[] concatArray = new byte[array1.length + array2.length];
        System.arraycopy(array1, 0, concatArray, 0, array1.length);
        System.arraycopy(array2, 0, concatArray, array1.length, array2.length);
        return concatArray;
    }

    public static byte[] concat(byte[] array1, int beginIndex1, int length1, byte[] array2, int beginIndex2, int length2) {
        byte[] concatArray = new byte[length1 + length2];
        System.arraycopy(array1, beginIndex1, concatArray, 0, length1);
        System.arraycopy(array2, beginIndex2, concatArray, length1, length2);
        return concatArray;
    }

    public static void sleep(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static String zeroUnPad(String s) {
        return ISOUtil.unPadLeft(s, '0');
    }

    public static String blankUnPad(String s) {
        return ISOUtil.unPadRight(s, ' ');
    }

    public static String unPadRight(String s, char c) {
        int end = s.length();
        if (end == 0) {
            return s;
        }
        while (0 < end && s.charAt(end - 1) == c) {
            --end;
        }
        return 0 < end ? s.substring(0, end) : s.substring(0, 1);
    }

    public static String unPadLeft(String s, char c) {
        int fill;
        int end = s.length();
        if (end == 0) {
            return s;
        }
        for (fill = 0; fill < end && s.charAt(fill) == c; ++fill) {
        }
        return fill < end ? s.substring(fill, end) : s.substring(fill - 1, end);
    }

    public static boolean isZero(String s) {
        int i;
        int len = s.length();
        for (i = 0; i < len && s.charAt(i) == '0'; ++i) {
        }
        return i >= len;
    }

    public static boolean isBlank(String s) {
        return s.trim().length() == 0;
    }

    public static boolean isAlphaNumeric(String s) {
        int i;
        int len = s.length();
        for (i = 0; i < len && (Character.isLetterOrDigit(s.charAt(i)) || s.charAt(i) == ' ' || s.charAt(i) == '.' || s.charAt(i) == '-' || s.charAt(i) == '_') || s.charAt(i) == '?'; ++i) {
        }
        return i >= len;
    }

    public static boolean isNumeric(String s, int radix) {
        int i;
        int len = s.length();
        for (i = 0; i < len && Character.digit(s.charAt(i), radix) > -1; ++i) {
        }
        return i >= len && len > 0;
    }

    public static byte[] bitSet2extendedByte(BitSet b) {
        int len = 128;
        byte[] d = new byte[len >> 3];
        for (int i = 0; i < len; ++i) {
            if (!b.get(i + 1)) continue;
            int n = i >> 3;
            d[n] = (byte)(d[n] | 128 >> i % 8);
        }
        d[0] = (byte)(d[0] | 0x80);
        return d;
    }

    public static int parseInt(String s, int radix) throws NumberFormatException {
        int digit;
        int length = s.length();
        if (length > 9) {
            throw new NumberFormatException("Number can have maximum 9 digits");
        }
        int index = 0;
        if ((digit = Character.digit(s.charAt(index++), radix)) == -1) {
            throw new NumberFormatException("String contains non-digit");
        }
        int result = digit;
        while (index < length) {
            result *= radix;
            if ((digit = Character.digit(s.charAt(index++), radix)) == -1) {
                throw new NumberFormatException("String contains non-digit");
            }
            result += digit;
        }
        return result;
    }

    public static int parseInt(String s) throws NumberFormatException {
        return ISOUtil.parseInt(s, 10);
    }

    public static int parseInt(char[] cArray, int radix) throws NumberFormatException {
        int digit;
        int length = cArray.length;
        if (length > 9) {
            throw new NumberFormatException("Number can have maximum 9 digits");
        }
        int index = 0;
        if ((digit = Character.digit(cArray[index++], radix)) == -1) {
            throw new NumberFormatException("Char array contains non-digit");
        }
        int result = digit;
        while (index < length) {
            result *= radix;
            if ((digit = Character.digit(cArray[index++], radix)) == -1) {
                throw new NumberFormatException("Char array contains non-digit");
            }
            result += digit;
        }
        return result;
    }

    public static int parseInt(char[] cArray) throws NumberFormatException {
        return ISOUtil.parseInt(cArray, 10);
    }

    public static int parseInt(byte[] bArray, int radix) throws NumberFormatException {
        int digit;
        int length = bArray.length;
        if (length > 9) {
            throw new NumberFormatException("Number can have maximum 9 digits");
        }
        int index = 0;
        if ((digit = Character.digit((char)bArray[index++], radix)) == -1) {
            throw new NumberFormatException("Byte array contains non-digit");
        }
        int result = digit;
        while (index < length) {
            result *= radix;
            if ((digit = Character.digit((char)bArray[index++], radix)) == -1) {
                throw new NumberFormatException("Byte array contains non-digit");
            }
            result += digit;
        }
        return result;
    }

    public static int parseInt(byte[] bArray) throws NumberFormatException {
        return ISOUtil.parseInt(bArray, 10);
    }

    private static String hexOffset(int i) {
        int w = (i = i >> 4 << 4) > 65535 ? 8 : 4;
        try {
            return ISOUtil.zeropad(Integer.toString(i, 16), w);
        }
        catch (RuntimeException e) {
            return e.getMessage();
        }
    }

    public static String hexdump(byte[] b) {
        return ISOUtil.hexdump(b, 0, b.length);
    }

    public static String hexdump(byte[] b, int offset) {
        return ISOUtil.hexdump(b, offset, b.length - offset);
    }

    public static String hexdump(byte[] b, int offset, int len) {
        StringBuilder sb = new StringBuilder();
        StringBuilder hex = new StringBuilder();
        StringBuilder ascii = new StringBuilder();
        String sep = "  ";
        String lineSep = System.getProperty("line.separator");
        len = offset + len;
        block4: for (int i = offset; i < len; ++i) {
            hex.append(hexStrings[b[i] & 0xFF]);
            hex.append(' ');
            char c = (char)b[i];
            ascii.append(c >= ' ' && c < '\u007f' ? c : (char)'.');
            int j = i % 16;
            switch (j) {
                case 7: {
                    hex.append(' ');
                    continue block4;
                }
                case 15: {
                    sb.append(ISOUtil.hexOffset(i));
                    sb.append(sep);
                    sb.append(hex.toString());
                    sb.append(' ');
                    sb.append(ascii.toString());
                    sb.append(lineSep);
                    hex = new StringBuilder();
                    ascii = new StringBuilder();
                }
            }
        }
        if (hex.length() > 0) {
            while (hex.length() < 49) {
                hex.append(' ');
            }
            sb.append(ISOUtil.hexOffset(len));
            sb.append(sep);
            sb.append(hex.toString());
            sb.append(' ');
            sb.append(ascii.toString());
            sb.append(lineSep);
        }
        return sb.toString();
    }

    public static String strpadf(String s, int len) {
        StringBuilder d = new StringBuilder(s);
        while (d.length() < len) {
            d.append('F');
        }
        return d.toString();
    }

    public static String trimf(String s) {
        int l;
        if (s != null && (l = s.length()) > 0) {
            while (--l >= 0 && s.charAt(l) == 'F') {
            }
            s = l == 0 ? "" : s.substring(0, l + 1);
        }
        return s;
    }

    public static String takeLastN(String s, int n) throws RuntimeException {
        if (s.length() > n) {
            return s.substring(s.length() - n);
        }
        if (s.length() < n) {
            return ISOUtil.zeropad(s, n);
        }
        return s;
    }

    public static String takeFirstN(String s, int n) throws RuntimeException {
        if (s.length() > n) {
            return s.substring(0, n);
        }
        if (s.length() < n) {
            return ISOUtil.zeropad(s, n);
        }
        return s;
    }

    public static String millisToString(long millis) {
        StringBuilder sb = new StringBuilder();
        int ms = (int)(millis % 1000L);
        int dd = (int)((millis /= 1000L) / 86400L);
        int hh = (int)((millis -= (long)(dd * 86400)) / 3600L);
        int mm = (int)((millis -= (long)(hh * 3600)) / 60L);
        int ss = (int)(millis -= (long)(mm * 60));
        if (dd > 0) {
            sb.append(Long.toString(dd));
            sb.append("d ");
        }
        sb.append(ISOUtil.zeropad(hh, 2));
        sb.append(':');
        sb.append(ISOUtil.zeropad(mm, 2));
        sb.append(':');
        sb.append(ISOUtil.zeropad(ss, 2));
        sb.append('.');
        sb.append(ISOUtil.zeropad(ms, 3));
        return sb.toString();
    }

    public static String formatAmountConversionRate(double convRate) throws RuntimeException {
        if (convRate == 0.0) {
            return null;
        }
        BigDecimal cr = new BigDecimal(convRate);
        int x = 7 - cr.precision() + cr.scale();
        String bds = cr.movePointRight(cr.scale()).toString();
        if (x > 9) {
            bds = ISOUtil.zeropad(bds, bds.length() + x - 9);
        }
        String ret = ISOUtil.zeropadRight(bds, 7);
        return Math.min(9, x) + ISOUtil.takeFirstN(ret, 7);
    }

    public static double parseAmountConversionRate(String convRate) {
        if (convRate == null || convRate.length() != 8) {
            throw new IllegalArgumentException("Invalid amount converion rate argument: '" + convRate + "'");
        }
        BigDecimal bd = new BigDecimal(convRate);
        int pow = bd.movePointLeft(7).intValue();
        bd = new BigDecimal(convRate.substring(1));
        return bd.movePointLeft(pow).doubleValue();
    }

    public static String commaEncode(String[] ss) {
        StringBuilder sb = new StringBuilder();
        for (String s : ss) {
            if (sb.length() > 0) {
                sb.append(',');
            }
            if (s == null) continue;
            for (int i = 0; i < s.length(); ++i) {
                char c = s.charAt(i);
                switch (c) {
                    case ',': 
                    case '\\': {
                        sb.append('\\');
                    }
                }
                sb.append(c);
            }
        }
        return sb.toString();
    }

    /*
     * Unable to fully structure code
     */
    public static String[] commaDecode(String s) {
        l = new ArrayList<String>();
        sb = new StringBuilder();
        escaped = false;
        block4: for (i = 0; i < s.length(); ++i) {
            c = s.charAt(i);
            if (escaped) ** GOTO lbl-1000
            switch (c) {
                case '\\': {
                    escaped = true;
                    continue block4;
                }
                case ',': {
                    l.add(sb.toString());
                    sb = new StringBuilder();
                    continue block4;
                }
                default: lbl-1000:
                // 2 sources

                {
                    sb.append(c);
                    escaped = false;
                }
            }
        }
        if (sb.length() > 0) {
            l.add(sb.toString());
        }
        return l.toArray(new String[l.size()]);
    }

    public static String commaDecode(String s, int i) {
        String[] ss = ISOUtil.commaDecode(s);
        int l = ss.length;
        return i >= 0 && i < l ? ss[i] : null;
    }

    public static char calcLUHN(String p) {
        int odd = p.length() % 2;
        int crc = 0;
        for (int i = 0; i < p.length(); ++i) {
            char c = p.charAt(i);
            if (!Character.isDigit(c)) {
                throw new IllegalArgumentException("Invalid PAN " + p);
            }
            c = (char)(c - 48);
            if (i % 2 != odd) {
                crc += c * 2 >= 10 ? c * 2 - 9 : c * 2;
                continue;
            }
            crc += c;
        }
        return (char)((crc % 10 == 0 ? 0 : 10 - crc % 10) + 48);
    }

    public static String getRandomDigits(Random r, int l, int radix) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < l; ++i) {
            sb.append(r.nextInt(radix));
        }
        return sb.toString();
    }

    static {
        for (int i = 0; i < 256; ++i) {
            StringBuilder d = new StringBuilder(2);
            char ch = Character.forDigit((byte)i >> 4 & 0xF, 16);
            d.append(Character.toUpperCase(ch));
            ch = Character.forDigit((byte)i & 0xF, 16);
            d.append(Character.toUpperCase(ch));
            ISOUtil.hexStrings[i] = d.toString();
        }
        CHARSET = Charset.forName(ENCODING);
        EBCDIC2ASCII = new byte[]{0, 1, 2, 3, -100, 9, -122, 127, -105, -115, -114, 11, 12, 13, 14, 15, 16, 17, 18, 19, -99, 10, 8, -121, 24, 25, -110, -113, 28, 29, 30, 31, -128, -127, -126, -125, -124, -123, 23, 27, -120, -119, -118, -117, -116, 5, 6, 7, -112, -111, 22, -109, -108, -107, -106, 4, -104, -103, -102, -101, 20, 21, -98, 26, 32, -96, -30, -28, -32, -31, -29, -27, -25, -15, -94, 46, 60, 40, 43, 124, 38, -23, -22, -21, -24, -19, -18, -17, -20, -33, 33, 36, 42, 41, 59, 94, 45, 47, -62, -60, -64, -63, -61, -59, -57, -47, -90, 44, 37, 95, 62, 63, -8, -55, -54, -53, -56, -51, -50, -49, -52, 96, 58, 35, 64, 39, 61, 34, -40, 97, 98, 99, 100, 101, 102, 103, 104, 105, -85, -69, -16, -3, -2, -79, -80, 106, 107, 108, 109, 110, 111, 112, 113, 114, -86, -70, -26, -72, -58, -92, -75, 126, 115, 116, 117, 118, 119, 120, 121, 122, -95, -65, -48, 91, -34, -82, -84, -93, -91, -73, -87, -89, -74, -68, -67, -66, -35, -88, -81, 93, -76, -41, 123, 65, 66, 67, 68, 69, 70, 71, 72, 73, -83, -12, -10, -14, -13, -11, 125, 74, 75, 76, 77, 78, 79, 80, 81, 82, -71, -5, -4, -7, -6, -1, 92, -9, 83, 84, 85, 86, 87, 88, 89, 90, -78, -44, -42, -46, -45, -43, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, -77, -37, -36, -39, -38, -97};
        ASCII2EBCDIC = new byte[]{0, 1, 2, 3, 55, 45, 46, 47, 22, 5, 21, 11, 12, 13, 14, 15, 16, 17, 18, 19, 60, 61, 50, 38, 24, 25, 63, 39, 28, 29, 30, 31, 64, 90, 127, 123, 91, 108, 80, 125, 77, 93, 92, 78, 107, 96, 75, 97, -16, -15, -14, -13, -12, -11, -10, -9, -8, -7, 122, 94, 76, 126, 110, 111, 124, -63, -62, -61, -60, -59, -58, -57, -56, -55, -47, -46, -45, -44, -43, -42, -41, -40, -39, -30, -29, -28, -27, -26, -25, -24, -23, -83, -32, -67, 95, 109, 121, -127, -126, -125, -124, -123, -122, -121, -120, -119, -111, -110, -109, -108, -107, -106, -105, -104, -103, -94, -93, -92, -91, -90, -89, -88, -87, -64, 79, -48, -95, 7, 32, 33, 34, 35, 36, 37, 6, 23, 40, 41, 42, 43, 44, 9, 10, 27, 48, 49, 26, 51, 52, 53, 54, 8, 56, 57, 58, 59, 4, 20, 62, -1, 65, -86, 74, -79, -97, -78, 106, -75, -69, -76, -102, -118, -80, -54, -81, -68, -112, -113, -22, -6, -66, -96, -74, -77, -99, -38, -101, -117, -73, -72, -71, -85, 100, 101, 98, 102, 99, 103, -98, 104, 116, 113, 114, 115, 120, 117, 118, 119, -84, 105, -19, -18, -21, -17, -20, -65, -128, -3, -2, -5, -4, -70, -82, 89, 68, 69, 66, 70, 67, 71, -100, 72, 84, 81, 82, 83, 88, 85, 86, 87, -116, 73, -51, -50, -53, -49, -52, -31, 112, -35, -34, -37, -36, -115, -114, -33};
    }
}

