/*
 * Decompiled with CFR 0.152.
 */
package com.github.fartherp.framework.common.util;

import com.github.fartherp.framework.common.util.FileUtilies;
import com.opencsv.CSVWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class CsvUtil {
    public static void writeCsvFile(HttpServletResponse response, HttpServletRequest request, String filename, String[] title, List<String[]> bodyList) {
        response.setContentType("application/octet-stream;charset=GBK");
        String fileName = FileUtilies.getFileName(filename, request);
        response.setHeader("Content-Disposition", "attachment; filename=" + fileName + ".csv");
        try (CSVWriter writer = new CSVWriter((Writer)response.getWriter());){
            if (title != null && title.length > 0) {
                writer.writeNext(title);
            }
            if (bodyList != null && bodyList.size() > 0) {
                writer.writeAll(bodyList);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("write csv file of response fail ", e);
        }
    }

    public static void writeCsvFile(String filename, String[] title, List<String[]> bodyList) {
        try (CSVWriter writer = new CSVWriter((Writer)new OutputStreamWriter((OutputStream)new FileOutputStream(new File(filename + ".csv")), "GBK"));){
            if (title != null && title.length > 0) {
                writer.writeNext(title);
            }
            if (bodyList != null && bodyList.size() > 0) {
                writer.writeAll(bodyList);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("write csv file fail ", e);
        }
    }

    public static String createCsvFile(List<List<Object>> outputList) {
        StringBuilder sb = new StringBuilder();
        char returnChar = '\r';
        char lineChar = '\n';
        for (List<Object> unitList : outputList) {
            if (unitList == null || unitList.isEmpty()) continue;
            sb.setLength(0);
            for (Object unitOb : unitList) {
                String unit = "";
                if (unitOb != null) {
                    unit = unitOb.toString().replaceAll(",", "");
                }
                sb.append(unit);
                sb.append(",");
            }
            sb.deleteCharAt(sb.length() - 1);
            sb.append(returnChar);
            sb.append(lineChar);
        }
        return sb.toString();
    }
}

