/*
 * Decompiled with CFR 0.152.
 */
package com.github.fartherp.framework.common.util;

import java.io.UnsupportedEncodingException;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import javax.mail.internet.MimeUtility;
import org.apache.commons.lang3.StringUtils;

public class WebUtil {
    public static String guessContentType(String fileName) {
        return URLConnection.getFileNameMap().getContentTypeFor(fileName);
    }

    public static String encodeContentDisposition(String userAgent, String fileName) {
        try {
            String lowUserAgent = userAgent.toLowerCase();
            if (lowUserAgent.contains("msie") || lowUserAgent.contains("trident")) {
                return "attachment;filename=" + StringUtils.replace((String)URLEncoder.encode(fileName, StandardCharsets.UTF_8.name()), (String)"+", (String)"%20");
            }
            if (lowUserAgent.contains("opera")) {
                return "attachment;filename*=UTF-8''" + fileName;
            }
            if (lowUserAgent.contains("safari") || lowUserAgent.contains("applewebkit") || lowUserAgent.contains("mozilla")) {
                return "attachment;filename=" + new String(fileName.getBytes(StandardCharsets.UTF_8), StandardCharsets.ISO_8859_1);
            }
            return "attachment;filename=" + MimeUtility.encodeWord((String)fileName);
        }
        catch (UnsupportedEncodingException e) {
            String charset = MimeUtility.getDefaultJavaCharset();
            throw new RuntimeException("default java charset [" + charset + "]", e);
        }
    }
}

