/*
 * Decompiled with CFR 0.152.
 */
package com.github.fartherp.framework.exception;

import com.github.fartherp.framework.exception.BaseException;
import com.github.fartherp.framework.exception.parse.PropertiesParse;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Properties;

public abstract class BaseSystemException
extends RuntimeException
implements BaseException {
    protected String message;
    protected String[] args;
    protected Throwable throwable;
    protected String database = "MYSQL";

    public BaseSystemException(String msg, Throwable t, String ... args) {
        if (args != null && args.length > 0) {
            Object[] obj = new Object[args.length];
            System.arraycopy(args, 0, obj, 0, args.length);
            this.message = MessageFormat.format(msg, obj);
        } else {
            this.message = msg;
        }
        this.args = args;
        this.throwable = t;
    }

    public BaseSystemException(String msg) {
        this.message = msg;
    }

    public BaseSystemException(Throwable t) {
        this.message = this.getMessage(t);
        this.throwable = t;
    }

    public BaseSystemException(String msg, Throwable t) {
        this.message = this.getMessage(t);
        if (null == this.message) {
            this.message = msg;
        }
        this.throwable = t;
    }

    public String getMessage() {
        return this.message;
    }

    public Throwable getThrowable() {
        return this.throwable;
    }

    public void setDatabase(String database) {
        this.database = database;
    }

    protected String getCommonMessage(Throwable t) {
        String oldMessage = "";
        Properties properties = PropertiesParse.getProperties("COMMON");
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String s = enumeration.nextElement().toString();
            if (!s.equals(t.getClass().getCanonicalName())) continue;
            oldMessage = properties.getProperty(s);
            break;
        }
        return oldMessage;
    }

    protected String getSQLException(Throwable t) {
        return this.getSQLException(t, PropertiesParse.getProperties("MYSQL"));
    }

    protected String getSQLException(Throwable t, Properties parse) {
        int errorCode = ((SQLException)t).getErrorCode();
        String temp = parse.getProperty(String.valueOf(errorCode));
        if (temp == null) {
            return parse.getProperty("unknow");
        }
        return temp.toString();
    }
}

