/*
 * Decompiled with CFR 0.152.
 */
package com.github.fartherp.framework.net.sftp;

import com.github.fartherp.framework.net.ftp.FtpUtils;
import com.github.fartherp.framework.net.sftp.ChannelType;
import com.github.fartherp.framework.net.sftp.ChannelWrapper;
import com.github.fartherp.framework.net.sftp.DirectTCPIPChannelWrapper;
import com.github.fartherp.framework.net.sftp.ExecChannelWrapper;
import com.github.fartherp.framework.net.sftp.ForwardedTCPIPChannelWrapper;
import com.github.fartherp.framework.net.sftp.SftpChannelWrapper;
import com.github.fartherp.framework.net.sftp.ShellChannelWrapper;
import com.github.fartherp.framework.net.sftp.SubsystemChannelWrapper;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChannelWrapperFactory {
    public static final Logger LOGGER = LoggerFactory.getLogger(FtpUtils.class);

    public static <T extends ChannelWrapper> T create(String host, String user, String password, int port, ChannelType channelType) throws JSchException {
        ChannelWrapper channelWrapper;
        LOGGER.info("prepare host:{}, user:{}, password:{}, port:{}", new Object[]{host, user, password, port});
        JSch jsch = new JSch();
        Session session = jsch.getSession(user, host, port);
        session.setPassword(password);
        Properties properties = new Properties();
        properties.put("StrictHostKeyChecking", "no");
        session.setConfig(properties);
        session.connect();
        LOGGER.info("host:{} connect success", (Object)host);
        switch (channelType) {
            case SFTP: {
                channelWrapper = new SftpChannelWrapper();
                break;
            }
            case EXEC: {
                channelWrapper = new ExecChannelWrapper();
                break;
            }
            case SHELL: {
                channelWrapper = new ShellChannelWrapper();
                break;
            }
            case DIRECT_TCP_IP: {
                channelWrapper = new DirectTCPIPChannelWrapper();
                break;
            }
            case FORWARDED_TCP_IP: {
                channelWrapper = new ForwardedTCPIPChannelWrapper();
                break;
            }
            case SUBSYSTEM: {
                channelWrapper = new SubsystemChannelWrapper();
                break;
            }
            default: {
                throw new IllegalArgumentException("channel type is not support.");
            }
        }
        LOGGER.info("host:{} create connect channel success", (Object)host);
        channelWrapper.setSession(session);
        channelWrapper.openChannel(channelType);
        return (T)channelWrapper;
    }
}

