/*
 * Decompiled with CFR 0.152.
 */
package com.github.fartherp.framework.net.sftp;

import com.github.fartherp.framework.net.sftp.ChannelType;
import com.github.fartherp.framework.net.sftp.ChannelWrapper;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.SftpException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Vector;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SftpChannelWrapper
extends ChannelWrapper<ChannelSftp> {
    public static final String FILE_NAME_SUFFIX = ".r";
    public static final String BLUR_NAME_TYPE = "";
    public static final String HMS_NAME_TYPE = "";

    @Override
    public void openChannel(ChannelType channelType) throws JSchException {
        super.openChannel(channelType);
        ((ChannelSftp)this.getChannel()).connect();
    }

    public void upload(String path, String localfilename, String remotefilename) throws SftpException {
        ((ChannelSftp)this.getChannel()).cd(path);
        File file = new File(localfilename);
        try {
            ((ChannelSftp)this.getChannel()).put((InputStream)new FileInputStream(file), remotefilename);
        }
        catch (FileNotFoundException e) {
            throw new SftpException(2, "local no such file ", (Throwable)e);
        }
    }

    public void upload(String localfilename, String path) throws SftpException {
        ((ChannelSftp)this.getChannel()).cd(path);
        String remoteName = SftpChannelWrapper.FtpFileName(localfilename);
        String remoteNameU = remoteName + FILE_NAME_SUFFIX;
        File file = new File(localfilename);
        try {
            ((ChannelSftp)this.getChannel()).put((InputStream)new FileInputStream(file), remoteNameU);
        }
        catch (FileNotFoundException e) {
            throw new SftpException(2, "local no such file ", (Throwable)e);
        }
        String srcFtpPath = path + File.separator + remoteNameU;
        String realFtpPath = path + File.separator + remoteName;
        ((ChannelSftp)this.getChannel()).rename(srcFtpPath, realFtpPath);
    }

    private static String FtpFileName(String inFile) {
        inFile = inFile.replace('\\', '/');
        int lastSlash = inFile.lastIndexOf(File.separator);
        return inFile.substring(lastSlash + 1, inFile.length());
    }

    public String getFile(String folder, String destinationFolder, String fileName, String nameType) throws SftpException {
        File fileFold;
        ChannelSftp.LsEntry file;
        Vector files = ((ChannelSftp)this.getChannel()).ls(folder);
        Iterator iter = files.iterator();
        if ("".equals(nameType.trim())) {
            while (iter.hasNext()) {
                file = (ChannelSftp.LsEntry)iter.next();
                String name = file.getFilename().toLowerCase();
                String fileNameStart = null;
                fileNameStart = fileName.contains(".") ? fileName.substring(0, fileName.lastIndexOf(".")).toLowerCase() : fileName.toLowerCase();
                if (!name.trim().startsWith(fileNameStart.trim())) continue;
                fileName = file.getFilename();
            }
        } else if ("".equals(nameType.trim())) {
            while (iter.hasNext()) {
                file = (ChannelSftp.LsEntry)iter.next();
                String name = file.getFilename().toLowerCase();
                String fileNameStart = fileName.toLowerCase();
                if (fileName.contains(".")) {
                    for (int length = Integer.parseInt(nameType.trim()); length > 0; --length) {
                        fileNameStart = fileNameStart.substring(0, fileNameStart.lastIndexOf("."));
                    }
                }
                if (!name.trim().startsWith(fileNameStart.trim())) continue;
                fileName = file.getFilename();
            }
        } else {
            while (iter.hasNext()) {
                file = (ChannelSftp.LsEntry)iter.next();
                String name = file.getFilename();
                if (!fileName.trim().equalsIgnoreCase(name)) continue;
                fileName = name;
            }
        }
        if (!(fileFold = new File(destinationFolder)).exists()) {
            fileFold.mkdirs();
        }
        String filePath = destinationFolder + File.separator + fileName;
        ((ChannelSftp)this.getChannel()).cd(folder);
        File file2 = new File(filePath);
        try {
            ((ChannelSftp)this.getChannel()).get(fileName, (OutputStream)new FileOutputStream(file2));
        }
        catch (FileNotFoundException e) {
            throw new SftpException(2, "local no such file ", (Throwable)e);
        }
        return fileName;
    }

    public void delFile(String folder, String destinationFolder, String fileName, String nameType) throws SftpException {
        Vector files = ((ChannelSftp)this.getChannel()).ls(folder);
        Iterator iter = files.iterator();
        if ("".equals(nameType.trim())) {
            while (iter.hasNext()) {
                ChannelSftp.LsEntry file = (ChannelSftp.LsEntry)iter.next();
                String name = file.getFilename().toLowerCase();
                String fileNameStart = null;
                fileNameStart = fileName.contains(".") ? fileName.substring(0, fileName.lastIndexOf(".")).toLowerCase() : fileName.toLowerCase();
                if (!name.trim().startsWith(fileNameStart.trim())) continue;
                fileName = file.getFilename();
            }
        } else if ("".equals(nameType.trim())) {
            while (iter.hasNext()) {
                ChannelSftp.LsEntry file = (ChannelSftp.LsEntry)iter.next();
                String name = file.getFilename().toLowerCase();
                String fileNameStart = fileName.toLowerCase();
                if (fileName.contains(".")) {
                    for (int length = Integer.parseInt(nameType.trim()); length > 0; --length) {
                        fileNameStart = fileNameStart.substring(0, fileNameStart.lastIndexOf("."));
                    }
                }
                if (!name.trim().startsWith(fileNameStart.trim())) continue;
                fileName = file.getFilename();
            }
        } else {
            while (iter.hasNext()) {
                ChannelSftp.LsEntry file = (ChannelSftp.LsEntry)iter.next();
                String name = file.getFilename();
                if (!fileName.trim().equalsIgnoreCase(name)) continue;
                fileName = name;
            }
        }
        ((ChannelSftp)this.getChannel()).cd(folder);
        ((ChannelSftp)this.getChannel()).rm(fileName);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isFileExist(String folder, String fileName, String nameType) throws SftpException {
        String name;
        boolean flag = false;
        int count = 0;
        Vector files = ((ChannelSftp)this.getChannel()).ls(folder);
        if (files.size() <= 0) return flag;
        Iterator iter = files.iterator();
        if ("".equals(nameType.trim())) {
            while (iter.hasNext()) {
                ChannelSftp.LsEntry file = (ChannelSftp.LsEntry)iter.next();
                String name2 = file.getFilename().toLowerCase();
                String fileNameStart = null;
                fileNameStart = fileName.contains(".") ? fileName.substring(0, fileName.lastIndexOf(".")).toLowerCase() : fileName.toLowerCase();
                if (!name2.trim().startsWith(fileNameStart.trim())) continue;
                ++count;
            }
            if (count != true) throw new RuntimeException("\u5339\u914d\u4e0a\u7684\u6587\u4ef6\u6570\u5927\u4e8e1");
            return true;
        }
        if ("".equals(nameType.trim())) {
            while (iter.hasNext()) {
                ChannelSftp.LsEntry file = (ChannelSftp.LsEntry)iter.next();
                String name3 = file.getFilename().toLowerCase();
                String fileNameStart = fileName.toLowerCase();
                if (fileName.contains(".")) {
                    for (int length = Integer.parseInt(nameType.trim()); length > 0; --length) {
                        fileNameStart = fileNameStart.substring(0, fileNameStart.lastIndexOf("."));
                    }
                }
                if (!name3.trim().startsWith(fileNameStart.trim())) continue;
                ++count;
            }
            if (count == 1) {
                return true;
            }
            if (count <= true) return flag;
            throw new RuntimeException("\u5339\u914d\u4e0a\u7684\u6587\u4ef6\u6570\u5927\u4e8e1");
        }
        do {
            if (!iter.hasNext()) return flag;
            ChannelSftp.LsEntry file = (ChannelSftp.LsEntry)iter.next();
            name = file.getFilename();
        } while (!fileName.trim().equalsIgnoreCase(name));
        return true;
    }

    public boolean rename(String from, String to) {
        try {
            ((ChannelSftp)this.getChannel()).rename(from, to);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public void mkdir(String path) throws SftpException {
        char[] result = path.toCharArray();
        ArrayList<String> dirs = new ArrayList<String>();
        for (int i = 0; i < result.length; ++i) {
            if (result[i] != '/') continue;
            dirs.add(path.substring(0, i));
        }
        if (!dirs.contains(path)) {
            dirs.add(path);
        }
        for (String dir : dirs) {
            try {
                if (!StringUtils.isNotBlank((String)dir)) continue;
                ((ChannelSftp)this.getChannel()).cd(dir);
            }
            catch (SftpException e) {
                if ("No such file".equals(e.getMessage())) {
                    // empty if block
                }
                ((ChannelSftp)this.getChannel()).mkdir(dir);
            }
        }
    }
}

