/*
 * Decompiled with CFR 0.152.
 */
package com.github.faster.framework.admin.role.controller;

import com.github.faster.framework.admin.role.entity.SysRole;
import com.github.faster.framework.admin.role.error.RoleError;
import com.github.faster.framework.admin.role.model.SysRoleReq;
import com.github.faster.framework.admin.role.service.SysRoleService;
import com.github.faster.framework.admin.rolePermission.entity.SysRolePermission;
import com.github.faster.framework.admin.rolePermission.error.RolePermissionError;
import com.github.faster.framework.admin.rolePermission.service.SysRolePermissionService;
import com.github.faster.framework.core.exception.model.ErrorCode;
import com.github.faster.framework.core.exception.model.ErrorResponseEntity;
import com.github.faster.framework.core.web.request.ListWrapper;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.BeanUtils;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/sys/roles"})
public class SysRoleController {
    private SysRoleService sysRoleService;
    private SysRolePermissionService sysRolePermissionService;

    @GetMapping
    @RequiresPermissions(value={"roles:list"})
    public ResponseEntity list(SysRole sysRole) {
        return ResponseEntity.ok(this.sysRoleService.list(sysRole));
    }

    @GetMapping(value={"/{roleId}"})
    @RequiresPermissions(value={"roles:info"})
    public ResponseEntity info(@PathVariable Long roleId) {
        return ResponseEntity.ok((Object)((Object)this.sysRoleService.info(roleId)));
    }

    @PostMapping
    @RequiresPermissions(value={"roles:add"})
    public ResponseEntity add(@Validated @RequestBody SysRoleReq request) {
        SysRole insert = new SysRole();
        BeanUtils.copyProperties((Object)request, (Object)((Object)insert));
        this.sysRoleService.add(insert);
        return new ResponseEntity(HttpStatus.CREATED);
    }

    @PutMapping(value={"/{roleId}"})
    @RequiresPermissions(value={"roles:modify"})
    public ResponseEntity update(@RequestBody SysRoleReq request, @PathVariable Long roleId) {
        SysRole update = new SysRole();
        BeanUtils.copyProperties((Object)request, (Object)((Object)update));
        update.setId(roleId);
        this.sysRoleService.update(update);
        return new ResponseEntity(HttpStatus.CREATED);
    }

    @DeleteMapping(value={"/{roleId}"})
    @RequiresPermissions(value={"roles:delete"})
    public ResponseEntity delete(@PathVariable Long roleId) {
        if (roleId == 0L) {
            return ErrorResponseEntity.error((ErrorCode)RoleError.ADMIN_CANNOT_DELETE, (HttpStatus)HttpStatus.BAD_REQUEST);
        }
        this.sysRoleService.delete(roleId);
        return new ResponseEntity(HttpStatus.NO_CONTENT);
    }

    @PutMapping(value={"/{roleId}/permissions/choose"})
    @RequiresPermissions(value={"roles:permissions:choose"})
    public ResponseEntity choosePermissions(@Validated @RequestBody ListWrapper<SysRolePermission> list, @PathVariable Long roleId) {
        if (roleId == 0L) {
            return ErrorResponseEntity.error((ErrorCode)RolePermissionError.CANNOT_CHOOSE_ADMIN_PERMISSION, (HttpStatus)HttpStatus.BAD_REQUEST);
        }
        this.sysRolePermissionService.batchChoose(list.getList(), roleId);
        return new ResponseEntity(HttpStatus.CREATED);
    }

    public SysRoleController(SysRoleService sysRoleService, SysRolePermissionService sysRolePermissionService) {
        this.sysRoleService = sysRoleService;
        this.sysRolePermissionService = sysRolePermissionService;
    }
}

