/*
 * Decompiled with CFR 0.152.
 */
package com.github.faster.framework.admin.role.service;

import com.github.faster.framework.admin.role.entity.SysRole;
import com.github.faster.framework.admin.role.mapper.SysRoleMapper;
import com.github.faster.framework.admin.rolePermission.service.SysRolePermissionService;
import com.github.faster.framework.admin.userRole.service.SysUserRoleService;
import com.github.faster.framework.core.entity.BaseEntity;
import com.github.pagehelper.PageInfo;
import org.apache.ibatis.session.RowBounds;
import org.apache.shiro.realm.AuthorizingRealm;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;
import tk.mybatis.mapper.entity.Example;
import tk.mybatis.mapper.entity.SqlsCriteria;
import tk.mybatis.mapper.weekend.WeekendSqls;

@Service
@Transactional
public class SysRoleService {
    private SysRoleMapper sysRoleMapper;
    private SysUserRoleService sysUserRoleService;
    private SysRolePermissionService sysRolePermissionService;
    private AuthorizingRealm authorizingRealm;

    public PageInfo<SysRole> list(SysRole sysRole) {
        WeekendSqls queryCondition = WeekendSqls.custom().andEqualTo(BaseEntity::getDeleted, (Object)0);
        if (!StringUtils.isEmpty((Object)sysRole.getName())) {
            queryCondition.andLike(SysRole::getName, sysRole.getName() + "%");
        }
        return this.sysRoleMapper.selectPageByExample((RowBounds)sysRole.rowBounds(), new Example.Builder(SysRole.class).where((SqlsCriteria)queryCondition).orderByDesc(new String[]{"createDate"}).build()).toPageInfo();
    }

    public SysRole info(Long roleId) {
        return (SysRole)((Object)this.sysRoleMapper.selectByPrimaryKey(roleId));
    }

    public void add(SysRole sysRole) {
        sysRole.preInsert();
        this.sysRoleMapper.insertSelective((Object)sysRole);
    }

    public void update(SysRole sysRole) {
        sysRole.preUpdate();
        this.sysRoleMapper.updateByPrimaryKeySelective((Object)sysRole);
    }

    public void delete(Long id) {
        SysRole delete = new SysRole();
        delete.setId(id);
        delete.setDeleted(1);
        delete.preUpdate();
        this.sysRoleMapper.updateByPrimaryKeySelective((Object)delete);
        this.sysUserRoleService.deleteByRoleId(id);
        this.sysRolePermissionService.deleteByRoleId(id);
        this.authorizingRealm.getAuthorizationCache().clear();
    }

    public SysRoleService(SysRoleMapper sysRoleMapper, SysUserRoleService sysUserRoleService, SysRolePermissionService sysRolePermissionService, AuthorizingRealm authorizingRealm) {
        this.sysRoleMapper = sysRoleMapper;
        this.sysUserRoleService = sysUserRoleService;
        this.sysRolePermissionService = sysRolePermissionService;
        this.authorizingRealm = authorizingRealm;
    }
}

