/*
 * Decompiled with CFR 0.152.
 */
package com.github.faster.framework.admin.shiro;

import com.github.faster.framework.admin.auth.error.AuthError;
import com.github.faster.framework.admin.shiro.ShiroFilter;
import com.github.faster.framework.admin.shiro.cache.ShiroCacheManager;
import com.github.faster.framework.core.exception.model.ErrorResponseEntity;
import com.github.faster.framework.core.exception.model.ResultError;
import java.util.LinkedHashMap;
import org.apache.shiro.authz.AuthorizationException;
import org.apache.shiro.cache.CacheManager;
import org.apache.shiro.mgt.DefaultSessionStorageEvaluator;
import org.apache.shiro.mgt.DefaultSubjectDAO;
import org.apache.shiro.mgt.SecurityManager;
import org.apache.shiro.mgt.SessionStorageEvaluator;
import org.apache.shiro.mgt.SubjectDAO;
import org.apache.shiro.realm.AuthorizingRealm;
import org.apache.shiro.realm.Realm;
import org.apache.shiro.spring.LifecycleBeanPostProcessor;
import org.apache.shiro.spring.security.interceptor.AuthorizationAttributeSourceAdvisor;
import org.apache.shiro.spring.web.ShiroFilterFactoryBean;
import org.apache.shiro.web.mgt.DefaultWebSecurityManager;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;

@Configuration
public class ShiroConfiguration {
    @Bean
    public LifecycleBeanPostProcessor lifecycleBeanPostProcessor() {
        return new LifecycleBeanPostProcessor();
    }

    @Bean
    public CacheManager cacheManager() {
        return new ShiroCacheManager();
    }

    @Bean
    public SecurityManager securityManager(AuthorizingRealm authorizingRealm) {
        authorizingRealm.setCacheManager(this.cacheManager());
        authorizingRealm.setAuthorizationCachingEnabled(true);
        DefaultWebSecurityManager securityManager = new DefaultWebSecurityManager();
        securityManager.setRealm((Realm)authorizingRealm);
        securityManager.setCacheManager(this.cacheManager());
        DefaultSubjectDAO subjectDAO = new DefaultSubjectDAO();
        DefaultSessionStorageEvaluator defaultSessionStorageEvaluator = new DefaultSessionStorageEvaluator();
        defaultSessionStorageEvaluator.setSessionStorageEnabled(false);
        subjectDAO.setSessionStorageEvaluator((SessionStorageEvaluator)defaultSessionStorageEvaluator);
        securityManager.setSubjectDAO((SubjectDAO)subjectDAO);
        return securityManager;
    }

    @Bean
    public AuthorizationAttributeSourceAdvisor authorizationAttributeSourceAdvisor(SecurityManager securityManager) {
        AuthorizationAttributeSourceAdvisor authorizationAttributeSourceAdvisor = new AuthorizationAttributeSourceAdvisor();
        authorizationAttributeSourceAdvisor.setSecurityManager(securityManager);
        return authorizationAttributeSourceAdvisor;
    }

    @Bean
    public ShiroFilterFactoryBean shiroFilter(SecurityManager securityManager) {
        ShiroFilterFactoryBean shiroFilterFactoryBean = new ShiroFilterFactoryBean();
        shiroFilterFactoryBean.setSecurityManager(securityManager);
        LinkedHashMap<String, String> filterChainDefinitionMap = new LinkedHashMap<String, String>();
        filterChainDefinitionMap.put("/login", "anon");
        filterChainDefinitionMap.put("/files/**", "anon");
        filterChainDefinitionMap.put("/**", "jwt");
        shiroFilterFactoryBean.setFilterChainDefinitionMap(filterChainDefinitionMap);
        LinkedHashMap<String, ShiroFilter> filters = new LinkedHashMap<String, ShiroFilter>();
        filters.put("jwt", new ShiroFilter());
        shiroFilterFactoryBean.setFilters(filters);
        return shiroFilterFactoryBean;
    }

    @ControllerAdvice
    @Configuration
    public static class ShiroExceptionHandler {
        @ResponseBody
        @ExceptionHandler(value={AuthorizationException.class})
        public Object handleException(AuthorizationException exception) {
            ResultError resultMsg = new ResultError(AuthError.NOT_HAVE_PERMISSION.getValue(), AuthError.NOT_HAVE_PERMISSION.getDescription() + "\uff1a" + exception.getMessage());
            return ErrorResponseEntity.error((ResultError)resultMsg, (HttpStatus)HttpStatus.BAD_REQUEST);
        }
    }
}

