/*
 * Decompiled with CFR 0.152.
 */
package com.github.faster.framework.admin.shiro;

import com.github.faster.framework.admin.permission.entity.SysPermission;
import com.github.faster.framework.admin.permission.service.SysPermissionService;
import com.github.faster.framework.admin.rolePermission.entity.SysRolePermission;
import com.github.faster.framework.admin.rolePermission.service.SysRolePermissionService;
import com.github.faster.framework.admin.user.entity.SysUser;
import com.github.faster.framework.admin.user.service.SysUserService;
import com.github.faster.framework.admin.userRole.entity.SysUserRole;
import com.github.faster.framework.admin.userRole.service.SysUserRoleService;
import com.github.faster.framework.core.auth.JwtService;
import com.github.faster.framework.core.cache.context.CacheFacade;
import com.github.faster.framework.core.exception.model.BasisErrorCode;
import com.github.faster.framework.core.web.context.RequestContext;
import com.github.faster.framework.core.web.context.WebContextFacade;
import io.jsonwebtoken.Claims;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.SimpleAuthenticationInfo;
import org.apache.shiro.authz.AuthorizationInfo;
import org.apache.shiro.authz.SimpleAuthorizationInfo;
import org.apache.shiro.realm.AuthorizingRealm;
import org.apache.shiro.subject.PrincipalCollection;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class ShiroRealm
extends AuthorizingRealm {
    @Autowired
    private SysUserService sysUserService;
    @Autowired
    private JwtService jwtService;
    @Autowired
    private SysUserRoleService sysUserRoleService;
    @Autowired
    private SysPermissionService sysPermissionService;
    @Autowired
    private SysRolePermissionService sysRolePermissionService;

    public boolean supports(AuthenticationToken token) {
        return token != null;
    }

    protected AuthorizationInfo doGetAuthorizationInfo(PrincipalCollection principalCollection) {
        List permissionCodeList;
        String jwtToken = (String)super.getAvailablePrincipal(principalCollection);
        Claims claims = this.jwtService.parseToken(jwtToken);
        if (claims == null) {
            throw new AuthenticationException(BasisErrorCode.TOKEN_INVALID.getDescription());
        }
        SysUser user = this.sysUserService.info(Long.parseLong(claims.getAudience()));
        SimpleAuthorizationInfo info = new SimpleAuthorizationInfo();
        if (user == null) {
            return info;
        }
        SysUserRole sysUserRoleQuery = new SysUserRole();
        sysUserRoleQuery.setUserId(user.getId());
        List<SysUserRole> sysUserRoleList = this.sysUserRoleService.list(sysUserRoleQuery);
        boolean isAdmin = sysUserRoleList.stream().anyMatch(userRole -> userRole.getRoleId() == 0L);
        info.setRoles(sysUserRoleList.stream().map(userRole -> userRole.getRoleId().toString()).collect(Collectors.toSet()));
        if (isAdmin) {
            permissionCodeList = this.sysPermissionService.selectAll().stream().map(SysPermission::getCode).collect(Collectors.toList());
        } else {
            List<Long> roleIds = sysUserRoleList.stream().map(SysUserRole::getRoleId).collect(Collectors.toList());
            List<Long> permissionIds = this.sysRolePermissionService.selectByRoleIdList(roleIds).stream().map(SysRolePermission::getPermissionId).collect(Collectors.toList());
            permissionCodeList = this.sysPermissionService.selectByIdList(permissionIds).stream().map(SysPermission::getCode).collect(Collectors.toList());
        }
        info.addStringPermissions(permissionCodeList);
        return info;
    }

    protected AuthenticationInfo doGetAuthenticationInfo(AuthenticationToken authenticationToken) throws AuthenticationException {
        try {
            String cacheToken;
            String token = (String)authenticationToken.getCredentials();
            Claims claims = this.jwtService.parseToken(token);
            if (claims == null) {
                throw new AuthenticationException(BasisErrorCode.TOKEN_INVALID.getDescription());
            }
            String userId = claims.getAudience();
            if (!(this.jwtService.isMultipartTerminal() || !StringUtils.isEmpty((Object)(cacheToken = (String)CacheFacade.get((String)("jwt-token:" + userId)))) && token.equals(cacheToken))) {
                throw new AuthenticationException(BasisErrorCode.TOKEN_INVALID.getDescription());
            }
            RequestContext requestContext = WebContextFacade.getRequestContext();
            requestContext.setUserId(Long.valueOf(Long.parseLong(userId)));
            WebContextFacade.setRequestContext((RequestContext)requestContext);
        }
        catch (Exception e) {
            throw new AuthenticationException(BasisErrorCode.TOKEN_INVALID.getDescription());
        }
        return new SimpleAuthenticationInfo(authenticationToken.getPrincipal(), authenticationToken.getCredentials(), this.getName());
    }
}

