/*
 * Decompiled with CFR 0.152.
 */
package com.github.faster.framework.admin.shiro.cache;

import com.github.faster.framework.core.cache.context.CacheFacade;
import java.util.Collection;
import java.util.Set;
import org.apache.shiro.cache.Cache;
import org.apache.shiro.cache.CacheException;

public class ShiroCache<K, V>
implements Cache<K, V> {
    private static final String CACHE_PREFIX = "shiro:";
    private String keyPrefix;

    public ShiroCache(String keyPrefix) {
        this.keyPrefix = CACHE_PREFIX + keyPrefix;
    }

    public V get(K k) throws CacheException {
        return (V)CacheFacade.get((String)(this.keyPrefix + k.toString()));
    }

    public V put(K k, V v) throws CacheException {
        CacheFacade.set((String)(this.keyPrefix + k.toString()), v, (long)0L);
        return v;
    }

    public V remove(K k) throws CacheException {
        return (V)CacheFacade.delete((String)(this.keyPrefix + k.toString()));
    }

    public void clear() throws CacheException {
        CacheFacade.clear((String)this.keyPrefix);
    }

    public int size() {
        return CacheFacade.size((String)this.keyPrefix);
    }

    public Set<K> keys() {
        return CacheFacade.keys((String)this.keyPrefix);
    }

    public Collection<V> values() {
        return CacheFacade.values((String)this.keyPrefix);
    }
}

