/*
 * Decompiled with CFR 0.152.
 */
package com.github.faster.framework.admin.user.controller;

import com.github.faster.framework.admin.user.entity.SysUser;
import com.github.faster.framework.admin.user.error.UserError;
import com.github.faster.framework.admin.user.model.SysUserAddReq;
import com.github.faster.framework.admin.user.model.SysUserChangePwdReq;
import com.github.faster.framework.admin.user.model.SysUserUpdateReq;
import com.github.faster.framework.admin.user.service.SysUserService;
import com.github.faster.framework.admin.userRole.entity.SysUserRole;
import com.github.faster.framework.admin.userRole.service.SysUserRoleService;
import com.github.faster.framework.core.exception.model.ErrorCode;
import com.github.faster.framework.core.exception.model.ErrorResponseEntity;
import com.github.faster.framework.core.web.request.ListWrapper;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.BeanUtils;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/sys/users"})
public class SysUserController {
    private SysUserService sysUserService;
    private SysUserRoleService sysUserRoleService;

    @GetMapping
    @RequiresPermissions(value={"users:list"})
    public ResponseEntity list(SysUser sysUser) {
        return ResponseEntity.ok(this.sysUserService.list(sysUser));
    }

    @GetMapping(value={"/{userId}"})
    @RequiresPermissions(value={"users:info"})
    public ResponseEntity info(@PathVariable Long userId) {
        return ResponseEntity.ok((Object)((Object)this.sysUserService.info(userId)));
    }

    @PostMapping
    @RequiresPermissions(value={"users:add"})
    public ResponseEntity add(@RequestBody @Validated SysUserAddReq sysUserAddReq) {
        SysUser sysUser = new SysUser();
        BeanUtils.copyProperties((Object)sysUserAddReq, (Object)((Object)sysUser));
        return this.sysUserService.add(sysUser);
    }

    @PutMapping(value={"/{userId}"})
    @RequiresPermissions(value={"users:modify"})
    public ResponseEntity update(@RequestBody SysUserUpdateReq sysUserUpdateReq, @PathVariable Long userId) {
        SysUser sysUser = new SysUser();
        BeanUtils.copyProperties((Object)sysUserUpdateReq, (Object)((Object)sysUser));
        sysUser.setId(userId);
        this.sysUserService.update(sysUser);
        return new ResponseEntity(HttpStatus.CREATED);
    }

    @DeleteMapping(value={"/{userId}"})
    @RequiresPermissions(value={"users:delete"})
    public ResponseEntity delete(@PathVariable Long userId) {
        if (userId == 0L) {
            return ErrorResponseEntity.error((ErrorCode)UserError.ADMIN_CANNOT_DELETE, (HttpStatus)HttpStatus.BAD_REQUEST);
        }
        this.sysUserService.delete(userId);
        return new ResponseEntity(HttpStatus.CREATED);
    }

    @PutMapping(value={"/{userId}/password/change"})
    @RequiresPermissions(value={"users:password:change"})
    public ResponseEntity changePwd(@Validated @RequestBody SysUserChangePwdReq sysUserChangePwdReq, @PathVariable Long userId) {
        return this.sysUserService.changePwd(sysUserChangePwdReq, userId);
    }

    @PutMapping(value={"/{userId}/password/reset"})
    @RequiresPermissions(value={"users:password:reset"})
    public ResponseEntity resetPwd(@PathVariable Long userId) {
        this.sysUserService.resetPwd(userId);
        return new ResponseEntity(HttpStatus.CREATED);
    }

    @PutMapping(value={"/{userId}/roles/choose"})
    @RequiresPermissions(value={"users:roles:choose"})
    public ResponseEntity chooseRoles(@Validated @RequestBody ListWrapper<SysUserRole> list, @PathVariable Long userId) {
        this.sysUserRoleService.batchChoose(list.getList(), userId);
        return new ResponseEntity(HttpStatus.CREATED);
    }

    public SysUserController(SysUserService sysUserService, SysUserRoleService sysUserRoleService) {
        this.sysUserService = sysUserService;
        this.sysUserRoleService = sysUserRoleService;
    }
}

