/*
 * Decompiled with CFR 0.152.
 */
package com.github.faster.framework.admin.user.service;

import com.github.faster.framework.admin.user.entity.SysUser;
import com.github.faster.framework.admin.user.error.UserError;
import com.github.faster.framework.admin.user.mapper.SysUserMapper;
import com.github.faster.framework.admin.user.model.SysUserChangePwdReq;
import com.github.faster.framework.admin.userRole.service.SysUserRoleService;
import com.github.faster.framework.core.entity.BaseEntity;
import com.github.faster.framework.core.exception.model.ErrorCode;
import com.github.faster.framework.core.exception.model.ErrorResponseEntity;
import com.github.faster.framework.core.utils.Utils;
import com.github.pagehelper.PageInfo;
import org.apache.ibatis.session.RowBounds;
import org.apache.shiro.realm.AuthorizingRealm;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;
import tk.mybatis.mapper.entity.Example;
import tk.mybatis.mapper.entity.SqlsCriteria;
import tk.mybatis.mapper.weekend.WeekendSqls;

@Service
@Transactional
public class SysUserService {
    private SysUserMapper sysUserMapper;
    private SysUserRoleService sysUserRoleService;
    private AuthorizingRealm authorizingRealm;

    public PageInfo<SysUser> list(SysUser sysUser) {
        WeekendSqls queryCondition = WeekendSqls.custom().andEqualTo(BaseEntity::getDeleted, (Object)0);
        if (!StringUtils.isEmpty((Object)sysUser.getName())) {
            queryCondition.andLike(SysUser::getName, sysUser.getName() + "%");
        }
        return this.sysUserMapper.selectPageByExample((RowBounds)sysUser.rowBounds(), new Example.Builder(SysUser.class).where((SqlsCriteria)queryCondition).orderByDesc(new String[]{"createDate"}).build()).toPageInfo();
    }

    public SysUser info(Long id) {
        return (SysUser)((Object)this.sysUserMapper.selectByPrimaryKey(id));
    }

    public ResponseEntity add(SysUser sysUser) {
        SysUser query = new SysUser();
        query.setAccount(sysUser.getAccount());
        SysUser exist = (SysUser)((Object)this.sysUserMapper.selectOne((Object)query));
        if (exist != null) {
            return ErrorResponseEntity.error((ErrorCode)UserError.USER_EXIST, (HttpStatus)HttpStatus.BAD_REQUEST);
        }
        sysUser.setPassword(Utils.md5((String)sysUser.getPassword()));
        sysUser.preInsert();
        this.sysUserMapper.insertSelective((Object)sysUser);
        return new ResponseEntity(HttpStatus.CREATED);
    }

    public void update(SysUser sysUser) {
        sysUser.preUpdate();
        this.sysUserMapper.updateByPrimaryKeySelective((Object)sysUser);
    }

    public void delete(Long userId) {
        SysUser delete = new SysUser();
        delete.setId(userId);
        delete.setDeleted(1);
        delete.preUpdate();
        this.sysUserMapper.updateByPrimaryKeySelective((Object)delete);
        this.sysUserRoleService.deleteByUserId(userId);
        this.authorizingRealm.getAuthorizationCache().clear();
    }

    public ResponseEntity changePwd(SysUserChangePwdReq sysUserChangePwdReq, Long userId) {
        SysUser existUser = (SysUser)((Object)this.sysUserMapper.selectByPrimaryKey(userId));
        if (existUser == null) {
            return ErrorResponseEntity.error((ErrorCode)UserError.USER_NOT_EXIST, (HttpStatus)HttpStatus.NOT_FOUND);
        }
        if (!existUser.getPassword().equals(Utils.md5((String)sysUserChangePwdReq.getOldPwd()))) {
            return ErrorResponseEntity.error((ErrorCode)UserError.OLD_PASSWORD_ERROR, (HttpStatus)HttpStatus.BAD_REQUEST);
        }
        SysUser update = new SysUser();
        update.setPassword(Utils.md5((String)sysUserChangePwdReq.getPassword()));
        update.setId(userId);
        update.preUpdate();
        this.sysUserMapper.updateByPrimaryKeySelective((Object)update);
        return new ResponseEntity(HttpStatus.CREATED);
    }

    public void resetPwd(Long userId) {
        SysUser update = new SysUser();
        update.setPassword(Utils.md5((String)"123456"));
        update.setId(userId);
        this.update(update);
    }

    public SysUserService(SysUserMapper sysUserMapper, SysUserRoleService sysUserRoleService, AuthorizingRealm authorizingRealm) {
        this.sysUserMapper = sysUserMapper;
        this.sysUserRoleService = sysUserRoleService;
        this.authorizingRealm = authorizingRealm;
    }
}

