/*
 * Decompiled with CFR 0.152.
 */
package com.github.faster.framework.admin.userRole.service;

import com.github.faster.framework.admin.userRole.entity.SysUserRole;
import com.github.faster.framework.admin.userRole.mapper.SysUserRoleMapper;
import java.util.List;
import org.apache.shiro.realm.AuthorizingRealm;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;
import tk.mybatis.mapper.entity.SqlsCriteria;
import tk.mybatis.mapper.weekend.WeekendSqls;

@Service
@Transactional
public class SysUserRoleService {
    private SysUserRoleMapper sysUserRoleMapper;
    private AuthorizingRealm authorizingRealm;

    public List<SysUserRole> list(SysUserRole sysUserRole) {
        return this.sysUserRoleMapper.select((Object)sysUserRole);
    }

    public void deleteByRoleId(Long roleId) {
        SysUserRole sysUserRole = new SysUserRole();
        sysUserRole.setDeleted(1);
        sysUserRole.preUpdate();
        this.sysUserRoleMapper.updateByExampleSelective((Object)sysUserRole, new Example.Builder(SysUserRole.class).where((SqlsCriteria)WeekendSqls.custom().andEqualTo(SysUserRole::getRoleId, (Object)roleId)).build());
    }

    public void deleteByUserId(Long userId) {
        SysUserRole sysUserRole = new SysUserRole();
        sysUserRole.setDeleted(1);
        sysUserRole.preUpdate();
        this.sysUserRoleMapper.updateByExampleSelective((Object)sysUserRole, new Example.Builder(SysUserRole.class).where((SqlsCriteria)WeekendSqls.custom().andEqualTo(SysUserRole::getUserId, (Object)userId)).build());
    }

    public void batchChoose(List<SysUserRole> list, Long userId) {
        this.deleteByUserId(userId);
        if (list.isEmpty()) {
            return;
        }
        list.forEach(item -> {
            item.setUserId(userId);
            item.preInsert();
        });
        this.sysUserRoleMapper.insertList(list);
        this.authorizingRealm.getAuthorizationCache().clear();
    }

    public SysUserRoleService(SysUserRoleMapper sysUserRoleMapper, AuthorizingRealm authorizingRealm) {
        this.sysUserRoleMapper = sysUserRoleMapper;
        this.authorizingRealm = authorizingRealm;
    }
}

