/*
 * Decompiled with CFR 0.152.
 */
package com.github.faster.framework.admin.auth.controller;

import com.github.faster.framework.admin.auth.model.LoginReq;
import com.github.faster.framework.admin.auth.service.AuthService;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class AuthController {
    private AuthService authService;

    @PostMapping(value={"/login"})
    public ResponseEntity login(@Validated @RequestBody LoginReq loginReq) {
        return this.authService.login(loginReq);
    }

    @GetMapping(value={"/permissions"})
    public ResponseEntity permissions() {
        return ResponseEntity.ok(this.authService.permissions());
    }

    @DeleteMapping(value={"/logout"})
    public ResponseEntity logout() {
        this.authService.logout();
        return new ResponseEntity(HttpStatus.NO_CONTENT);
    }

    public AuthController(AuthService authService) {
        this.authService = authService;
    }
}

