/*
 * Decompiled with CFR 0.152.
 */
package com.github.faster.framework.admin.auth.service;

import com.github.faster.framework.admin.auth.error.AuthError;
import com.github.faster.framework.admin.auth.model.LoginReq;
import com.github.faster.framework.admin.auth.model.LoginRes;
import com.github.faster.framework.admin.user.entity.SysUser;
import com.github.faster.framework.admin.user.mapper.SysUserMapper;
import com.github.faster.framework.core.auth.JwtService;
import com.github.faster.framework.core.captcha.service.ICaptchaService;
import com.github.faster.framework.core.exception.model.ErrorCode;
import com.github.faster.framework.core.exception.model.ErrorResponseEntity;
import com.github.faster.framework.core.utils.Utils;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authz.AuthorizationInfo;
import org.apache.shiro.cache.Cache;
import org.apache.shiro.realm.AuthorizingRealm;
import org.apache.shiro.subject.PrincipalCollection;
import org.apache.shiro.subject.Subject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

@Service
public class AuthService {
    @Autowired
    private SysUserMapper sysUserMapper;
    @Autowired
    private JwtService jwtService;
    @Autowired
    private AuthorizingRealm authorizingRealm;
    @Autowired
    private ICaptchaService captchaService;

    public ResponseEntity login(LoginReq loginReq) {
        if (!this.captchaService.validCaptcha(loginReq.getCaptcha(), loginReq.getCaptchaToken())) {
            return ErrorResponseEntity.error((ErrorCode)AuthError.CAPTCHA_ERROR, (HttpStatus)HttpStatus.NOT_FOUND);
        }
        SysUser query = new SysUser();
        query.setAccount(loginReq.getAccount());
        SysUser existUser = (SysUser)((Object)this.sysUserMapper.selectOne((Object)query));
        if (existUser == null) {
            return ErrorResponseEntity.error((ErrorCode)AuthError.USER_NOT_EXIST, (HttpStatus)HttpStatus.NOT_FOUND);
        }
        if (!existUser.getPassword().equals(Utils.md5((String)loginReq.getPassword()))) {
            return ErrorResponseEntity.error((ErrorCode)AuthError.PASSWORD_ERROR, (HttpStatus)HttpStatus.NOT_FOUND);
        }
        final String token = this.jwtService.createToken((Object)existUser.getId(), 0L);
        Subject subject = SecurityUtils.getSubject();
        subject.login(new AuthenticationToken(){

            public Object getPrincipal() {
                return token;
            }

            public Object getCredentials() {
                return token;
            }
        });
        LoginRes loginRes = new LoginRes();
        loginRes.setToken(token);
        loginRes.setName(existUser.getName());
        return ResponseEntity.ok((Object)loginRes);
    }

    public void logout() {
        PrincipalCollection principalCollection = SecurityUtils.getSubject().getPrincipals();
        if (principalCollection != null) {
            this.authorizingRealm.getAuthorizationCache().remove((Object)principalCollection);
        }
    }

    public Collection<String> permissions() {
        Cache cache = this.authorizingRealm.getAuthorizationCache();
        AuthorizationInfo authorizationInfo = (AuthorizationInfo)cache.get((Object)SecurityUtils.getSubject().getPrincipals());
        if (authorizationInfo == null) {
            SecurityUtils.getSubject().isPermitted("permissions");
            authorizationInfo = (AuthorizationInfo)cache.get((Object)SecurityUtils.getSubject().getPrincipals());
        }
        return authorizationInfo == null ? new ArrayList() : authorizationInfo.getStringPermissions();
    }
}

