/*
 * Decompiled with CFR 0.152.
 */
package com.github.faster.framework.admin.permission.controller;

import com.github.faster.framework.admin.permission.entity.SysPermission;
import com.github.faster.framework.admin.permission.model.SysPermissionAddReq;
import com.github.faster.framework.admin.permission.model.SysPermissionUpdateReq;
import com.github.faster.framework.admin.permission.service.SysPermissionService;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.BeanUtils;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/sys/permissions"})
public class SysPermissionController {
    private SysPermissionService sysPermissionService;

    @GetMapping(value={"/tree"})
    @RequiresPermissions(value={"permissions:tree"})
    public ResponseEntity tree() {
        return ResponseEntity.ok(this.sysPermissionService.treeList());
    }

    @GetMapping
    @RequiresPermissions(value={"permissions:list"})
    public ResponseEntity list() {
        return ResponseEntity.ok(this.sysPermissionService.list());
    }

    @GetMapping(value={"/{permissionId}"})
    @RequiresPermissions(value={"permissions:info"})
    public ResponseEntity info(@PathVariable Long permissionId) {
        return ResponseEntity.ok((Object)((Object)this.sysPermissionService.info(permissionId)));
    }

    @PostMapping
    @RequiresPermissions(value={"permissions:add"})
    public ResponseEntity add(@Validated @RequestBody SysPermissionAddReq request) {
        SysPermission insert = new SysPermission();
        BeanUtils.copyProperties((Object)request, (Object)((Object)insert));
        return this.sysPermissionService.add(insert);
    }

    @PutMapping(value={"/{permissionId}"})
    @RequiresPermissions(value={"permissions:modify"})
    public ResponseEntity update(@RequestBody SysPermissionUpdateReq request, @PathVariable Long permissionId) {
        SysPermission update = new SysPermission();
        BeanUtils.copyProperties((Object)request, (Object)((Object)update));
        update.setId(permissionId);
        return this.sysPermissionService.update(update);
    }

    @DeleteMapping(value={"/{permissionId}"})
    @RequiresPermissions(value={"permissions:delete"})
    public ResponseEntity delete(@PathVariable Long permissionId) {
        this.sysPermissionService.delete(permissionId);
        return new ResponseEntity(HttpStatus.NO_CONTENT);
    }

    public SysPermissionController(SysPermissionService sysPermissionService) {
        this.sysPermissionService = sysPermissionService;
    }
}

