/*
 * Decompiled with CFR 0.152.
 */
package com.github.faster.framework.admin.permission.service;

import com.github.faster.framework.admin.permission.entity.SysPermission;
import com.github.faster.framework.admin.permission.error.SysPermissionError;
import com.github.faster.framework.admin.permission.mapper.SysPermissionMapper;
import com.github.faster.framework.admin.rolePermission.service.SysRolePermissionService;
import com.github.faster.framework.core.entity.BaseEntity;
import com.github.faster.framework.core.entity.TreeNode;
import com.github.faster.framework.core.exception.model.ErrorCode;
import com.github.faster.framework.core.exception.model.ErrorResponseEntity;
import com.github.faster.framework.core.utils.tree.TreeUtils;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.shiro.realm.AuthorizingRealm;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;
import tk.mybatis.mapper.entity.Example;
import tk.mybatis.mapper.entity.SqlsCriteria;
import tk.mybatis.mapper.weekend.WeekendSqls;

@Service
@Transactional
public class SysPermissionService {
    private SysPermissionMapper sysPermissionMapper;
    private SysRolePermissionService sysRolePermissionService;
    private AuthorizingRealm authorizingRealm;

    public List<TreeNode> treeList() {
        List list = this.sysPermissionMapper.selectByExample(Example.builder(SysPermission.class).where((SqlsCriteria)WeekendSqls.custom().andEqualTo(BaseEntity::getDeleted, (Object)0)).orderByAsc(new String[]{"parentIds"}).build()).stream().sorted(Comparator.comparing(BaseEntity::getSort)).collect(Collectors.toList());
        return TreeUtils.convertToTree(list);
    }

    public List<SysPermission> selectAll() {
        SysPermission sysPermission = new SysPermission();
        sysPermission.setDeleted(0);
        return this.sysPermissionMapper.select((Object)sysPermission);
    }

    public SysPermission info(Long permissionId) {
        return (SysPermission)((Object)this.sysPermissionMapper.selectByPrimaryKey(permissionId));
    }

    public ResponseEntity add(SysPermission sysPermission) {
        boolean existParentId = this.completeParentIds(sysPermission);
        if (!existParentId) {
            return ErrorResponseEntity.error((ErrorCode)SysPermissionError.PERMISSION_PARENT_NOT_EXIST, (HttpStatus)HttpStatus.BAD_REQUEST);
        }
        if (!StringUtils.isEmpty((Object)sysPermission.getCode()) && this.existCode(sysPermission.getCode())) {
            return ErrorResponseEntity.error((ErrorCode)SysPermissionError.PERMISSION_CODE_EXIST, (HttpStatus)HttpStatus.BAD_REQUEST);
        }
        sysPermission.preInsert();
        this.sysPermissionMapper.insertSelective((Object)sysPermission);
        return new ResponseEntity(HttpStatus.CREATED);
    }

    private boolean completeParentIds(SysPermission sysPermission) {
        if (sysPermission.getParentId() != 0L) {
            SysPermission existParent = (SysPermission)((Object)this.sysPermissionMapper.selectByPrimaryKey(sysPermission.getParentId()));
            if (existParent == null) {
                return false;
            }
            sysPermission.setParentIds(existParent.getParentIds().concat(",").concat("[").concat(existParent.getId().toString()).concat("]"));
        } else {
            sysPermission.setParentIds("[0]");
        }
        return true;
    }

    private boolean existCode(String code) {
        SysPermission query = new SysPermission();
        query.setDeleted(0);
        query.setCode(code);
        return this.sysPermissionMapper.selectOne((Object)query) != null;
    }

    public ResponseEntity update(SysPermission sysPermission) {
        SysPermission oldPermission;
        if (!StringUtils.isEmpty((Object)sysPermission.getCode()) && (oldPermission = (SysPermission)((Object)this.sysPermissionMapper.selectByPrimaryKey(sysPermission.getId()))) != null && !sysPermission.getCode().equals(oldPermission.getCode()) && this.existCode(sysPermission.getCode())) {
            return ErrorResponseEntity.error((ErrorCode)SysPermissionError.PERMISSION_CODE_EXIST, (HttpStatus)HttpStatus.BAD_REQUEST);
        }
        sysPermission.preUpdate();
        this.sysPermissionMapper.updateByPrimaryKeySelective((Object)sysPermission);
        return new ResponseEntity(HttpStatus.CREATED);
    }

    public void delete(Long id) {
        List<Long> delList = this.sysPermissionMapper.selectByExample(new Example.Builder(SysPermission.class).where((SqlsCriteria)WeekendSqls.custom().andLike(SysPermission::getParentIds, "%[".concat(id.toString()).concat("]%"))).build()).stream().map(BaseEntity::getId).collect(Collectors.toList());
        delList.add(id);
        SysPermission delete = new SysPermission();
        delete.setDeleted(1);
        delete.preUpdate();
        this.sysPermissionMapper.updateByExampleSelective((Object)delete, new Example.Builder(SysPermission.class).where((SqlsCriteria)WeekendSqls.custom().andIn(BaseEntity::getId, delList)).build());
        this.sysRolePermissionService.deleteByPermissionIdList(delList);
        this.authorizingRealm.getAuthorizationCache().clear();
    }

    public List<SysPermission> selectByIdList(List<Long> idList) {
        return this.sysPermissionMapper.selectByIdList(idList);
    }

    public List<SysPermission> list() {
        return this.sysPermissionMapper.selectByExample(Example.builder(SysPermission.class).where((SqlsCriteria)WeekendSqls.custom().andEqualTo(BaseEntity::getDeleted, (Object)0)).orderByAsc(new String[]{"parentIds"}).build()).stream().sorted(Comparator.comparing(BaseEntity::getSort)).collect(Collectors.toList());
    }

    public SysPermissionService(SysPermissionMapper sysPermissionMapper, SysRolePermissionService sysRolePermissionService, AuthorizingRealm authorizingRealm) {
        this.sysPermissionMapper = sysPermissionMapper;
        this.sysRolePermissionService = sysRolePermissionService;
        this.authorizingRealm = authorizingRealm;
    }
}

