/*
 * Decompiled with CFR 0.152.
 */
package com.github.faster.framework.admin.rolePermission.service;

import com.github.faster.framework.admin.rolePermission.entity.SysRolePermission;
import com.github.faster.framework.admin.rolePermission.mapper.SysRolePermissionMapper;
import com.github.faster.framework.core.entity.BaseEntity;
import java.util.List;
import org.apache.shiro.realm.AuthorizingRealm;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.PathVariable;
import tk.mybatis.mapper.entity.Example;
import tk.mybatis.mapper.entity.SqlsCriteria;
import tk.mybatis.mapper.weekend.WeekendSqls;

@Service
@Transactional
public class SysRolePermissionService {
    private SysRolePermissionMapper sysRolePermissionMapper;
    private AuthorizingRealm authorizingRealm;

    public List<SysRolePermission> selectByRoleIdList(List<Long> roleIdList) {
        return this.sysRolePermissionMapper.selectByExample(new Example.Builder(SysRolePermission.class).selectDistinct(new String[]{"permissionId"}).where((SqlsCriteria)WeekendSqls.custom().andEqualTo(BaseEntity::getDeleted, (Object)0).andIn(SysRolePermission::getRoleId, roleIdList)).build());
    }

    public void deleteByRoleId(Long roleId) {
        this.sysRolePermissionMapper.deleteByExample(new Example.Builder(SysRolePermission.class).where((SqlsCriteria)WeekendSqls.custom().andEqualTo(SysRolePermission::getRoleId, (Object)roleId)).build());
    }

    public void deleteByPermissionIdList(List<Long> permissionIdList) {
        this.sysRolePermissionMapper.deleteByExample(new Example.Builder(SysRolePermission.class).where((SqlsCriteria)WeekendSqls.custom().andIn(SysRolePermission::getPermissionId, permissionIdList)).build());
    }

    public void batchChoose(List<SysRolePermission> list, @PathVariable Long roleId) {
        this.deleteByRoleId(roleId);
        this.authorizingRealm.getAuthorizationCache().clear();
        if (list == null || list.isEmpty()) {
            return;
        }
        list.forEach(item -> {
            item.setRoleId(roleId);
            item.preInsert();
        });
        this.sysRolePermissionMapper.insertList(list);
    }

    public SysRolePermissionService(SysRolePermissionMapper sysRolePermissionMapper, AuthorizingRealm authorizingRealm) {
        this.sysRolePermissionMapper = sysRolePermissionMapper;
        this.authorizingRealm = authorizingRealm;
    }
}

