/*
 * Decompiled with CFR 0.152.
 */
package com.github.faster.framework.admin.shiro;

import com.alibaba.fastjson.JSON;
import com.github.faster.framework.core.exception.model.BasisErrorCode;
import com.github.faster.framework.core.exception.model.ErrorCode;
import com.github.faster.framework.core.exception.model.ResultError;
import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.web.filter.authc.AuthenticatingFilter;
import org.apache.shiro.web.util.WebUtils;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.RequestMethod;

public class ShiroFilter
extends AuthenticatingFilter {
    protected AuthenticationToken createToken(ServletRequest servletRequest, ServletResponse servletResponse) throws Exception {
        HttpServletRequest httpServletRequest = (HttpServletRequest)servletRequest;
        final String jwtToken = httpServletRequest.getHeader("Authorization");
        return new AuthenticationToken(){

            public Object getPrincipal() {
                return jwtToken;
            }

            public Object getCredentials() {
                return jwtToken;
            }
        };
    }

    protected boolean onAccessDenied(ServletRequest servletRequest, ServletResponse servletResponse) throws Exception {
        return this.executeLogin(servletRequest, servletResponse);
    }

    protected boolean onLoginFailure(AuthenticationToken token, AuthenticationException e, ServletRequest request, ServletResponse response) {
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        httpResponse.setStatus(HttpStatus.UNAUTHORIZED.value());
        httpResponse.setContentType("application/json;charset=utf-8");
        try (PrintWriter printWriter = httpResponse.getWriter();){
            printWriter.write(JSON.toJSONString((Object)new ResultError((ErrorCode)BasisErrorCode.TOKEN_INVALID, HttpStatus.UNAUTHORIZED)));
            printWriter.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    protected boolean preHandle(ServletRequest request, ServletResponse response) throws Exception {
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        httpResponse.setHeader("Access-Control-Allow-Origin", "*");
        httpResponse.setHeader("Access-Control-Allow-Methods", "*");
        httpResponse.setHeader("Access-Control-Allow-Headers", "*");
        httpResponse.setHeader("Access-Control-Allow-Credentials", "true");
        if (RequestMethod.OPTIONS.name().equals(WebUtils.toHttp((ServletRequest)request).getMethod())) {
            httpResponse.setStatus(HttpStatus.OK.value());
            httpResponse.setStatus(HttpStatus.OK.value());
            return false;
        }
        return super.preHandle(request, response);
    }
}

