/*
 * Decompiled with CFR 0.152.
 */
package com.github.faster.framework.admin.userRole.service;

import com.github.faster.framework.admin.userRole.entity.SysUserRole;
import com.github.faster.framework.admin.userRole.mapper.SysUserRoleMapper;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.shiro.realm.AuthorizingRealm;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;
import tk.mybatis.mapper.entity.SqlsCriteria;
import tk.mybatis.mapper.weekend.WeekendSqls;

@Service
@Transactional
public class SysUserRoleService {
    private SysUserRoleMapper sysUserRoleMapper;
    private AuthorizingRealm authorizingRealm;

    public List<SysUserRole> list(SysUserRole sysUserRole) {
        return this.sysUserRoleMapper.select((Object)sysUserRole);
    }

    public void deleteByRoleId(Long roleId) {
        this.sysUserRoleMapper.deleteByExample(new Example.Builder(SysUserRole.class).where((SqlsCriteria)WeekendSqls.custom().andEqualTo(SysUserRole::getRoleId, (Object)roleId)).build());
    }

    public void deleteByUserId(Long userId) {
        this.sysUserRoleMapper.deleteByExample(new Example.Builder(SysUserRole.class).where((SqlsCriteria)WeekendSqls.custom().andEqualTo(SysUserRole::getUserId, (Object)userId)).build());
    }

    public void batchChoose(List<SysUserRole> list, Long userId) {
        this.deleteByUserId(userId);
        this.authorizingRealm.getAuthorizationCache().clear();
        if (list.isEmpty()) {
            return;
        }
        list.forEach(item -> {
            item.setUserId(userId);
            item.preInsert();
        });
        this.sysUserRoleMapper.insertList(list);
    }

    public List<Long> roles(Long userId) {
        SysUserRole userRole = new SysUserRole();
        userRole.setUserId(userId);
        userRole.setDeleted(0);
        return this.sysUserRoleMapper.select((Object)userRole).stream().map(SysUserRole::getRoleId).collect(Collectors.toList());
    }

    public SysUserRoleService(SysUserRoleMapper sysUserRoleMapper, AuthorizingRealm authorizingRealm) {
        this.sysUserRoleMapper = sysUserRoleMapper;
        this.authorizingRealm = authorizingRealm;
    }
}

