/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonpatch;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jackson.JacksonUtils;
import com.github.fge.jsonpatch.JsonPatchException;
import com.github.fge.jsonpatch.JsonPatchMessages;
import com.github.fge.jsonpatch.JsonPatchOperation;
import com.github.fge.msgsimple.bundle.MessageBundle;
import com.github.fge.msgsimple.load.MessageBundles;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.List;

public final class JsonPatch {
    private static final MessageBundle BUNDLE = MessageBundles.getBundle(JsonPatchMessages.class);
    private final List<JsonPatchOperation> operations;

    @JsonCreator
    @VisibleForTesting
    JsonPatch(List<JsonPatchOperation> operations) {
        this.operations = ImmutableList.copyOf(operations);
    }

    public static JsonPatch fromJson(JsonNode node) throws IOException {
        BUNDLE.checkNotNull((Object)node, "jsonPatch.nullInput");
        return (JsonPatch)JacksonUtils.getReader().withType(JsonPatch.class).readValue(node);
    }

    public JsonNode apply(JsonNode node) throws JsonPatchException {
        BUNDLE.checkNotNull((Object)node, "jsonPatch.nullInput");
        JsonNode ret = node;
        for (JsonPatchOperation operation : this.operations) {
            ret = operation.apply(ret);
        }
        return ret;
    }

    public String toString() {
        return this.operations.toString();
    }
}

