/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.tree;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.fge.jsonschema.exceptions.JsonReferenceException;
import com.github.fge.jsonschema.jsonpointer.JsonPointer;
import com.github.fge.jsonschema.jsonpointer.TokenResolver;
import com.github.fge.jsonschema.ref.JsonRef;
import com.github.fge.jsonschema.tree.SchemaTree;
import com.github.fge.jsonschema.util.JacksonUtils;
import java.util.Iterator;
import net.jcip.annotations.Immutable;

@Immutable
public abstract class BaseSchemaTree
implements SchemaTree {
    private static final JsonNodeFactory FACTORY = JacksonUtils.nodeFactory();
    private final JsonRef dollarSchema;
    protected final JsonNode baseNode;
    protected final JsonPointer pointer;
    private final JsonNode node;
    protected final JsonRef loadingRef;
    private final JsonRef startingRef;
    private final JsonRef currentRef;

    protected BaseSchemaTree(JsonRef loadingRef, JsonNode baseNode, JsonPointer pointer) {
        this.dollarSchema = BaseSchemaTree.extractDollarSchema(baseNode);
        this.baseNode = baseNode;
        this.pointer = pointer;
        this.node = pointer.path(baseNode);
        this.loadingRef = loadingRef;
        JsonRef ref = BaseSchemaTree.idFromNode(baseNode);
        this.startingRef = ref == null ? loadingRef : loadingRef.resolve(ref);
        this.currentRef = BaseSchemaTree.nextRef(this.startingRef, pointer, baseNode);
    }

    protected BaseSchemaTree(BaseSchemaTree other, JsonPointer newPointer) {
        this.dollarSchema = other.dollarSchema;
        this.baseNode = other.baseNode;
        this.loadingRef = other.loadingRef;
        this.pointer = newPointer;
        this.node = newPointer.get(this.baseNode);
        this.startingRef = other.startingRef;
        this.currentRef = BaseSchemaTree.nextRef(this.startingRef, newPointer, this.baseNode);
    }

    @Override
    public final JsonNode getBaseNode() {
        return this.baseNode;
    }

    @Override
    public final JsonPointer getPointer() {
        return this.pointer;
    }

    @Override
    public final JsonNode getNode() {
        return this.node;
    }

    @Override
    public final JsonRef resolve(JsonRef other) {
        return this.currentRef.resolve(other);
    }

    @Override
    public final JsonRef getDollarSchema() {
        return this.dollarSchema;
    }

    @Override
    public final JsonRef getLoadingRef() {
        return this.loadingRef;
    }

    @Override
    public final JsonRef getContext() {
        return this.currentRef;
    }

    @Override
    public final JsonNode asJson() {
        ObjectNode ret = FACTORY.objectNode();
        ret.put("loadingURI", (JsonNode)FACTORY.textNode(this.loadingRef.toString()));
        ret.put("pointer", (JsonNode)FACTORY.textNode(this.pointer.toString()));
        return ret;
    }

    public final String toString() {
        return "loading URI: " + this.loadingRef + "; current pointer: " + this.pointer + "; resolution context: " + this.currentRef;
    }

    protected static JsonRef idFromNode(JsonNode node) {
        if (!node.path("id").isTextual()) {
            return null;
        }
        try {
            return JsonRef.fromString(node.get("id").textValue());
        }
        catch (JsonReferenceException ignored) {
            return null;
        }
    }

    private static JsonRef nextRef(JsonRef startingRef, JsonPointer ptr, JsonNode startingNode) {
        TokenResolver<JsonNode> resolver;
        JsonRef ret = startingRef;
        JsonNode node = startingNode;
        Iterator i$ = ptr.iterator();
        while (i$.hasNext() && (node = (resolver = i$.next()).get(node)) != null) {
            JsonRef idRef = BaseSchemaTree.idFromNode(node);
            if (idRef == null) continue;
            ret = ret.resolve(idRef);
        }
        return ret;
    }

    private static JsonRef extractDollarSchema(JsonNode schema) {
        JsonNode node = schema.path("$schema");
        if (!node.isTextual()) {
            return JsonRef.emptyRef();
        }
        try {
            JsonRef ref = JsonRef.fromString(node.textValue());
            return ref.isAbsolute() ? ref : JsonRef.emptyRef();
        }
        catch (JsonReferenceException ignored) {
            return JsonRef.emptyRef();
        }
    }
}

