/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.metaschema;

import com.github.fge.jsonschema.format.FormatAttribute;
import com.github.fge.jsonschema.keyword.KeywordValidator;
import com.github.fge.jsonschema.main.Keyword;
import com.github.fge.jsonschema.syntax.SyntaxChecker;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Map;

public final class KeywordRegistry {
    private final Map<String, SyntaxChecker> syntaxCheckers = Maps.newHashMap();
    private final Map<String, Class<? extends KeywordValidator>> validators = Maps.newHashMap();
    private final Map<String, FormatAttribute> formatAttributes = Maps.newHashMap();

    void addSyntaxCheckers(Map<String, SyntaxChecker> map) {
        this.syntaxCheckers.putAll(map);
    }

    public Map<String, SyntaxChecker> getSyntaxCheckers() {
        return ImmutableMap.copyOf(this.syntaxCheckers);
    }

    void addValidators(Map<String, Class<? extends KeywordValidator>> map) {
        this.validators.putAll(map);
    }

    public Map<String, Class<? extends KeywordValidator>> getValidators() {
        return ImmutableMap.copyOf(this.validators);
    }

    public void addKeyword(Keyword keyword) {
        Class<? extends KeywordValidator> validator;
        Preconditions.checkNotNull((Object)keyword, (Object)"keyword must not be null");
        String name = keyword.getName();
        this.removeKeyword(name);
        SyntaxChecker checker = keyword.getSyntaxChecker();
        if (checker != null) {
            this.syntaxCheckers.put(name, checker);
        }
        if ((validator = keyword.getValidatorClass()) != null) {
            this.validators.put(name, validator);
        }
    }

    public void removeKeyword(String name) {
        Preconditions.checkNotNull((Object)name, (Object)"name must not be null");
        this.syntaxCheckers.remove(name);
        this.validators.remove(name);
    }

    void addFormatAttributes(Map<String, FormatAttribute> map) {
        this.formatAttributes.putAll(map);
    }

    public void addFormatAttribute(String name, FormatAttribute formatAttribute) {
        Preconditions.checkNotNull((Object)name, (Object)"name must not be null");
        Preconditions.checkNotNull((Object)formatAttribute, (Object)"format attribute must not be null");
        this.formatAttributes.put(name, formatAttribute);
    }

    public void removeFormatAttribute(String name) {
        Preconditions.checkNotNull((Object)name, (Object)"name must not be null");
        this.formatAttributes.remove(name);
    }

    public Map<String, FormatAttribute> getFormatAttributes() {
        return ImmutableMap.copyOf(this.formatAttributes);
    }
}

