/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.metaschema;

import com.github.fge.jsonschema.keyword.KeywordValidator;
import com.github.fge.jsonschema.keyword.common.AdditionalItemsKeywordValidator;
import com.github.fge.jsonschema.keyword.common.AdditionalPropertiesKeywordValidator;
import com.github.fge.jsonschema.keyword.common.EnumKeywordValidator;
import com.github.fge.jsonschema.keyword.common.FormatKeywordValidator;
import com.github.fge.jsonschema.keyword.common.MaxItemsKeywordValidator;
import com.github.fge.jsonschema.keyword.common.MaxLengthKeywordValidator;
import com.github.fge.jsonschema.keyword.common.MaximumKeywordValidator;
import com.github.fge.jsonschema.keyword.common.MinItemsKeywordValidator;
import com.github.fge.jsonschema.keyword.common.MinLengthKeywordValidator;
import com.github.fge.jsonschema.keyword.common.MinimumKeywordValidator;
import com.github.fge.jsonschema.keyword.common.PatternKeywordValidator;
import com.github.fge.jsonschema.keyword.common.UniqueItemsKeywordValidator;
import com.github.fge.jsonschema.keyword.draftv3.DisallowKeywordValidator;
import com.github.fge.jsonschema.keyword.draftv3.DivisibleByKeywordValidator;
import com.github.fge.jsonschema.keyword.draftv3.DraftV3DependenciesKeywordValidator;
import com.github.fge.jsonschema.keyword.draftv3.DraftV3PropertiesKeywordValidator;
import com.github.fge.jsonschema.keyword.draftv3.DraftV3TypeKeywordValidator;
import com.github.fge.jsonschema.keyword.draftv3.ExtendsKeywordValidator;
import com.github.fge.jsonschema.keyword.draftv4.AllOfKeywordValidator;
import com.github.fge.jsonschema.keyword.draftv4.AnyOfKeywordValidator;
import com.github.fge.jsonschema.keyword.draftv4.DraftV4DependenciesKeywordValidator;
import com.github.fge.jsonschema.keyword.draftv4.DraftV4TypeKeywordValidator;
import com.github.fge.jsonschema.keyword.draftv4.MaxPropertiesKeywordValidator;
import com.github.fge.jsonschema.keyword.draftv4.MinPropertiesKeywordValidator;
import com.github.fge.jsonschema.keyword.draftv4.MultipleOfKeywordValidator;
import com.github.fge.jsonschema.keyword.draftv4.NotKeywordValidator;
import com.github.fge.jsonschema.keyword.draftv4.OneOfKeywordValidator;
import com.github.fge.jsonschema.keyword.draftv4.RequiredKeywordValidator;
import com.google.common.collect.ImmutableMap;
import java.util.Map;

public final class KeywordValidators {
    private static final Map<String, Class<? extends KeywordValidator>> DRAFTV3;
    private static final Map<String, Class<? extends KeywordValidator>> DRAFTV4;

    private KeywordValidators() {
    }

    static Map<String, Class<? extends KeywordValidator>> draftV3() {
        return DRAFTV3;
    }

    static Map<String, Class<? extends KeywordValidator>> draftV4() {
        return DRAFTV4;
    }

    static {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        String keyword = "additionalItems";
        Class validator = AdditionalItemsKeywordValidator.class;
        builder.put((Object)keyword, validator);
        keyword = "minItems";
        validator = MinItemsKeywordValidator.class;
        builder.put((Object)keyword, validator);
        keyword = "maxItems";
        validator = MaxItemsKeywordValidator.class;
        builder.put((Object)keyword, validator);
        keyword = "uniqueItems";
        validator = UniqueItemsKeywordValidator.class;
        builder.put((Object)keyword, validator);
        keyword = "minimum";
        validator = MinimumKeywordValidator.class;
        builder.put((Object)keyword, validator);
        keyword = "maximum";
        validator = MaximumKeywordValidator.class;
        builder.put((Object)keyword, validator);
        keyword = "additionalProperties";
        validator = AdditionalPropertiesKeywordValidator.class;
        builder.put((Object)keyword, validator);
        keyword = "minLength";
        validator = MinLengthKeywordValidator.class;
        builder.put((Object)keyword, validator);
        keyword = "maxLength";
        validator = MaxLengthKeywordValidator.class;
        builder.put((Object)keyword, validator);
        keyword = "pattern";
        validator = PatternKeywordValidator.class;
        builder.put((Object)keyword, validator);
        keyword = "enum";
        validator = EnumKeywordValidator.class;
        builder.put((Object)keyword, validator);
        keyword = "format";
        validator = FormatKeywordValidator.class;
        builder.put((Object)keyword, validator);
        ImmutableMap common = builder.build();
        builder = ImmutableMap.builder();
        builder.putAll((Map)common);
        keyword = "divisibleBy";
        validator = DivisibleByKeywordValidator.class;
        builder.put((Object)keyword, validator);
        keyword = "properties";
        validator = DraftV3PropertiesKeywordValidator.class;
        builder.put((Object)keyword, validator);
        keyword = "dependencies";
        validator = DraftV3DependenciesKeywordValidator.class;
        builder.put((Object)keyword, validator);
        keyword = "type";
        validator = DraftV3TypeKeywordValidator.class;
        builder.put((Object)keyword, validator);
        keyword = "disallow";
        validator = DisallowKeywordValidator.class;
        builder.put((Object)keyword, validator);
        keyword = "extends";
        validator = ExtendsKeywordValidator.class;
        builder.put((Object)keyword, validator);
        DRAFTV3 = builder.build();
        builder = ImmutableMap.builder();
        builder.putAll((Map)common);
        keyword = "multipleOf";
        validator = MultipleOfKeywordValidator.class;
        builder.put((Object)keyword, validator);
        keyword = "minProperties";
        validator = MinPropertiesKeywordValidator.class;
        builder.put((Object)keyword, validator);
        keyword = "maxProperties";
        validator = MaxPropertiesKeywordValidator.class;
        builder.put((Object)keyword, validator);
        keyword = "required";
        validator = RequiredKeywordValidator.class;
        builder.put((Object)keyword, validator);
        keyword = "dependencies";
        validator = DraftV4DependenciesKeywordValidator.class;
        builder.put((Object)keyword, validator);
        keyword = "anyOf";
        validator = AnyOfKeywordValidator.class;
        builder.put((Object)keyword, validator);
        keyword = "allOf";
        validator = AllOfKeywordValidator.class;
        builder.put((Object)keyword, validator);
        keyword = "oneOf";
        validator = OneOfKeywordValidator.class;
        builder.put((Object)keyword, validator);
        keyword = "not";
        validator = NotKeywordValidator.class;
        builder.put((Object)keyword, validator);
        keyword = "type";
        validator = DraftV4TypeKeywordValidator.class;
        builder.put((Object)keyword, validator);
        DRAFTV4 = builder.build();
    }
}

