/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.ref;

import com.github.fge.jsonschema.main.JsonSchemaException;
import com.github.fge.jsonschema.ref.EmptyJsonRef;
import com.github.fge.jsonschema.ref.HierarchicalJsonRef;
import com.github.fge.jsonschema.ref.JarJsonRef;
import com.github.fge.jsonschema.ref.JsonFragment;
import com.github.fge.jsonschema.report.Domain;
import com.github.fge.jsonschema.report.Message;
import com.google.common.base.Preconditions;
import java.net.URI;
import java.net.URISyntaxException;

public abstract class JsonRef {
    private static final URI EMPTY_URI = URI.create("");
    protected static final URI HASHONLY_URI = URI.create("#");
    protected final URI uri;
    protected final URI locator;
    protected final JsonFragment fragment;
    private final String asString;
    private final int hashCode;

    protected JsonRef(URI uri) {
        String scheme = uri.getScheme();
        String ssp = uri.getSchemeSpecificPart();
        String uriFragment = uri.getFragment();
        String realFragment = uriFragment == null ? "" : uriFragment;
        try {
            this.uri = new URI(scheme, ssp, realFragment);
            this.locator = new URI(scheme, ssp, "");
            this.fragment = JsonFragment.fromFragment(realFragment);
            this.asString = this.uri.toString();
            this.hashCode = this.asString.hashCode();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("WTF??", e);
        }
    }

    public static JsonRef fromURI(URI uri) {
        Preconditions.checkNotNull((Object)uri, (Object)"URI must not be null");
        URI normalized = uri.normalize();
        if (HASHONLY_URI.equals(normalized) || EMPTY_URI.equals(normalized)) {
            return EmptyJsonRef.getInstance();
        }
        return "jar".equals(normalized.getScheme()) ? new JarJsonRef(normalized) : new HierarchicalJsonRef(normalized);
    }

    public static JsonRef fromString(String s) throws JsonSchemaException {
        Preconditions.checkNotNull((Object)s, (Object)"string must not be null");
        try {
            return JsonRef.fromURI(new URI(s));
        }
        catch (URISyntaxException e) {
            Message.Builder msg = Domain.REF_RESOLVING.newMessage().setKeyword("N/A").addInfo("uri", s).setMessage("invalid URI");
            throw JsonSchemaException.wrap(msg.build(), e);
        }
    }

    public static JsonRef emptyRef() {
        return EmptyJsonRef.getInstance();
    }

    public final URI toURI() {
        return this.uri;
    }

    public abstract boolean isAbsolute();

    public abstract JsonRef resolve(JsonRef var1);

    public final URI getLocator() {
        return this.locator;
    }

    public final JsonFragment getFragment() {
        return this.fragment;
    }

    public final boolean contains(JsonRef other) {
        return this.locator.equals(other.locator);
    }

    public final int hashCode() {
        return this.hashCode;
    }

    public final boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof JsonRef)) {
            return false;
        }
        JsonRef that = (JsonRef)obj;
        return this.asString.equals(that.asString);
    }

    public final String toString() {
        return this.asString;
    }
}

