/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.syntax;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jsonschema.report.Message;
import com.github.fge.jsonschema.syntax.AbstractSyntaxChecker;
import com.github.fge.jsonschema.syntax.SyntaxValidator;
import com.github.fge.jsonschema.util.NodeType;
import java.util.List;

public final class SchemaOrSchemaArraySyntaxChecker
extends AbstractSyntaxChecker {
    private final boolean allowEmptyArrays;

    public SchemaOrSchemaArraySyntaxChecker(String keyword, boolean allowEmptyArrays) {
        super(keyword, NodeType.ARRAY, NodeType.OBJECT);
        this.allowEmptyArrays = allowEmptyArrays;
    }

    @Override
    public void checkValue(SyntaxValidator validator, List<Message> messages, JsonNode schema) {
        JsonNode node = schema.get(this.keyword);
        Message.Builder msg = this.newMsg();
        if (!node.isArray()) {
            validator.validate(messages, node);
            return;
        }
        int size = node.size();
        if (size == 0 && !this.allowEmptyArrays) {
            msg.setMessage("array must have at least one element");
            messages.add(msg.build());
            return;
        }
        for (int index = 0; index < size; ++index) {
            JsonNode subSchema = node.get(index);
            NodeType type = NodeType.getNodeType(node.get(index));
            if (type != NodeType.OBJECT) {
                msg.setMessage("incorrect type for array element").addInfo("index", index).addInfo("found", type).addInfo("expected", NodeType.OBJECT);
                messages.add(msg.build());
                continue;
            }
            validator.validate(messages, subSchema);
        }
    }
}

