/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.syntax.draftv3;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jsonschema.report.Message;
import com.github.fge.jsonschema.syntax.AbstractSyntaxChecker;
import com.github.fge.jsonschema.syntax.SyntaxChecker;
import com.github.fge.jsonschema.syntax.SyntaxValidator;
import com.github.fge.jsonschema.util.NodeType;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public final class DraftV3PropertiesSyntaxChecker
extends AbstractSyntaxChecker {
    private static final SyntaxChecker INSTANCE = new DraftV3PropertiesSyntaxChecker();

    private DraftV3PropertiesSyntaxChecker() {
        super("properties", NodeType.OBJECT, new NodeType[0]);
    }

    public static SyntaxChecker getInstance() {
        return INSTANCE;
    }

    @Override
    public void checkValue(SyntaxValidator validator, List<Message> messages, JsonNode schema) {
        JsonNode node = schema.get(this.keyword);
        HashSet fields = Sets.newHashSet((Iterator)node.fieldNames());
        for (String field : Ordering.natural().sortedCopy((Iterable)fields)) {
            Message.Builder msg = this.newMsg().addInfo("key", field);
            JsonNode element = node.get(field);
            NodeType type = NodeType.getNodeType(element);
            if (type != NodeType.OBJECT) {
                msg.setMessage("key value has incorrect type").addInfo("expected", NodeType.OBJECT).addInfo("found", type);
                messages.add(msg.build());
                continue;
            }
            if (element.has("required") && (type = NodeType.getNodeType(element.get("required"))) != NodeType.BOOLEAN) {
                msg.setMessage("\"required\" attribute has incorrect type").addInfo("expected", NodeType.BOOLEAN).addInfo("found", type);
                messages.add(msg.build());
                continue;
            }
            validator.validate(messages, element);
        }
    }
}

