/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.validator;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jsonschema.format.FormatAttribute;
import com.github.fge.jsonschema.schema.SchemaContainer;
import com.github.fge.jsonschema.schema.SchemaNode;
import com.github.fge.jsonschema.validator.JsonValidator;
import com.github.fge.jsonschema.validator.JsonValidatorCache;

public final class ValidationContext {
    private final JsonValidatorCache cache;
    private SchemaContainer container;

    public ValidationContext(JsonValidatorCache cache) {
        this.cache = cache;
    }

    SchemaContainer getContainer() {
        return this.container;
    }

    void setContainer(SchemaContainer container) {
        this.container = container;
    }

    public FormatAttribute getFormat(String fmt) {
        return this.cache.getFormatAttributes().get(fmt);
    }

    public JsonValidator newValidator(JsonNode node) {
        SchemaNode schemaNode = new SchemaNode(this.container, node);
        return this.cache.getValidator(schemaNode);
    }

    public String toString() {
        return "current: " + this.container;
    }
}

