/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.keyword.syntax.common;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jsonschema.exceptions.ProcessingException;
import com.github.fge.jsonschema.jsonpointer.JsonPointer;
import com.github.fge.jsonschema.keyword.syntax.AbstractSyntaxChecker;
import com.github.fge.jsonschema.keyword.syntax.SyntaxChecker;
import com.github.fge.jsonschema.messages.SyntaxMessages;
import com.github.fge.jsonschema.report.ProcessingReport;
import com.github.fge.jsonschema.tree.SchemaTree;
import com.github.fge.jsonschema.util.NodeType;
import com.github.fge.jsonschema.util.equivalence.JsonSchemaEquivalence;
import com.google.common.base.Equivalence;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;

public final class EnumSyntaxChecker
extends AbstractSyntaxChecker {
    private static final Equivalence<JsonNode> EQUIVALENCE = JsonSchemaEquivalence.getInstance();
    private static final SyntaxChecker INSTANCE = new EnumSyntaxChecker();

    public static SyntaxChecker getInstance() {
        return INSTANCE;
    }

    private EnumSyntaxChecker() {
        super("enum", NodeType.ARRAY, new NodeType[0]);
    }

    @Override
    protected void checkValue(Collection<JsonPointer> pointers, ProcessingReport report, SchemaTree tree) throws ProcessingException {
        HashSet set = Sets.newHashSet();
        for (JsonNode element : this.getNode(tree)) {
            if (set.add(EQUIVALENCE.wrap((Object)element))) continue;
            report.error(this.newMsg(tree, SyntaxMessages.ELEMENTS_NOT_UNIQUE));
            return;
        }
    }
}

