/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.keyword.syntax.helpers;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jsonschema.exceptions.ProcessingException;
import com.github.fge.jsonschema.jsonpointer.JsonPointer;
import com.github.fge.jsonschema.keyword.syntax.AbstractSyntaxChecker;
import com.github.fge.jsonschema.report.ProcessingReport;
import com.github.fge.jsonschema.tree.SchemaTree;
import com.github.fge.jsonschema.util.NodeType;
import java.util.Collection;

public abstract class SchemaOrSchemaArraySyntaxChecker
extends AbstractSyntaxChecker {
    protected SchemaOrSchemaArraySyntaxChecker(String keyword) {
        super(keyword, NodeType.ARRAY, NodeType.OBJECT);
    }

    @Override
    protected final void checkValue(Collection<JsonPointer> pointers, ProcessingReport report, SchemaTree tree) throws ProcessingException {
        this.collectPointers(pointers, tree);
        this.extraChecks(report, tree);
    }

    protected abstract void extraChecks(ProcessingReport var1, SchemaTree var2) throws ProcessingException;

    private void collectPointers(Collection<JsonPointer> pointers, SchemaTree tree) {
        JsonNode node = this.getNode(tree);
        if (node.isObject()) {
            pointers.add(JsonPointer.of((Object)this.keyword, (Object[])new Object[0]));
            return;
        }
        for (int index = 0; index < node.size(); ++index) {
            pointers.add(JsonPointer.of((Object)this.keyword, (Object[])new Object[]{index}));
        }
    }
}

