/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.keyword.validator.common;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jsonschema.exceptions.ProcessingException;
import com.github.fge.jsonschema.keyword.validator.AbstractKeywordValidator;
import com.github.fge.jsonschema.messages.KeywordValidationMessages;
import com.github.fge.jsonschema.processing.Processor;
import com.github.fge.jsonschema.processors.data.FullData;
import com.github.fge.jsonschema.report.ProcessingReport;
import com.github.fge.jsonschema.util.equivalence.JsonSchemaEquivalence;
import com.google.common.base.Equivalence;
import com.google.common.collect.Sets;
import java.util.HashSet;

public final class UniqueItemsValidator
extends AbstractKeywordValidator {
    private static final Equivalence<JsonNode> EQUIVALENCE = JsonSchemaEquivalence.getInstance();
    private final boolean uniqueItems;

    public UniqueItemsValidator(JsonNode digest) {
        super("uniqueItems");
        this.uniqueItems = digest.get(this.keyword).booleanValue();
    }

    @Override
    public void validate(Processor<FullData, ProcessingReport> processor, ProcessingReport report, FullData data) throws ProcessingException {
        if (!this.uniqueItems) {
            return;
        }
        HashSet set = Sets.newHashSet();
        JsonNode node = data.getInstance().getNode();
        for (JsonNode element : node) {
            if (set.add(EQUIVALENCE.wrap((Object)element))) continue;
            report.error(this.newMsg(data).message((Object)KeywordValidationMessages.ELEMENTS_NOT_UNIQUE));
            return;
        }
    }

    @Override
    public String toString() {
        return this.keyword + ": " + this.uniqueItems;
    }
}

