/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.keyword.validator.helpers;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.github.fge.jsonschema.keyword.validator.AbstractKeywordValidator;
import com.github.fge.jsonschema.util.JacksonUtils;
import com.github.fge.jsonschema.util.NodeType;
import com.google.common.collect.Lists;
import java.util.EnumSet;
import java.util.List;

public abstract class DraftV3TypeKeywordValidator
extends AbstractKeywordValidator {
    protected static final JsonNodeFactory FACTORY = JacksonUtils.nodeFactory();
    protected final EnumSet<NodeType> types = EnumSet.noneOf(NodeType.class);
    protected final List<Integer> schemas = Lists.newArrayList();

    protected DraftV3TypeKeywordValidator(String keyword, JsonNode digested) {
        super(keyword);
        for (JsonNode element : digested.get(keyword)) {
            this.types.add(NodeType.fromName((String)element.textValue()));
        }
        for (JsonNode element : digested.get("schemas")) {
            this.schemas.add(element.intValue());
        }
    }

    @Override
    public final String toString() {
        return this.keyword + ": " + this.types + "; " + this.schemas.size() + " schemas";
    }
}

